/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.testsupport.util;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;

public final class TestClock
extends Clock {
    private Instant current;

    public static TestClock now() {
        return new TestClock(Instant.now());
    }

    public static TestClock now(Clock clock) {
        return new TestClock(Instant.now(clock));
    }

    public static TestClock now(long millis) {
        return new TestClock(Instant.ofEpochMilli(millis));
    }

    private TestClock(Instant current) {
        this.current = current;
    }

    @Override
    public ZoneId getZone() {
        return ZoneId.systemDefault();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Instant instant() {
        return this.current;
    }

    public void proceed(long amount, TemporalUnit unit) {
        this.current = this.current.plus(amount, unit);
    }
}

