/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.testsupport.togglz;

import de.otto.edison.testsupport.togglz.TestFeatureManager;
import de.otto.edison.testsupport.togglz.TestFeatureManagerProvider;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.FeatureAnnotations;

public class FeatureManagerSupport {
    public static void allEnabledFeatureConfig(Class<? extends Feature> featureClass) {
        TestFeatureManager featureManager = new TestFeatureManager(featureClass);
        FeatureManagerSupport.enableAllFeaturesThatAreOkToEnableByDefaultInAllTests(featureClass, featureManager);
        TestFeatureManagerProvider.setFeatureManager(featureManager);
        FeatureContext.clearCache();
    }

    public static void allDisabledFeatureConfig(Class<? extends Feature> featureClass) {
        TestFeatureManager featureManager = new TestFeatureManager(featureClass);
        for (Feature feature : featureClass.getEnumConstants()) {
            featureManager.disable(feature);
        }
        TestFeatureManagerProvider.setFeatureManager(featureManager);
        FeatureContext.clearCache();
    }

    public static void disable(Feature feature) {
        FeatureContext.getFeatureManager().setFeatureState(new FeatureState(feature, false));
    }

    private static void enableAllFeaturesThatAreOkToEnableByDefaultInAllTests(Class<? extends Feature> featureClass, TestFeatureManager featureManager) {
        for (Feature feature : featureClass.getEnumConstants()) {
            if (!FeatureManagerSupport.shouldRunInTests(feature)) continue;
            featureManager.enable(feature);
        }
    }

    public static boolean shouldRunInTests(Feature feature) {
        String label = FeatureAnnotations.getLabel((Feature)feature);
        return !label.contains("[inactiveInTests]");
    }

    public static void enable(Feature feature) {
        FeatureContext.getFeatureManager().setFeatureState(new FeatureState(feature, true));
    }
}

