/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.testsupport.matcher;

import java.util.Optional;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class OptionalMatchers {
    public static Matcher<? super Optional<?>> isPresent() {
        return new BaseMatcher<Optional<?>>(){

            public boolean matches(Object item) {
                return Optional.class.isAssignableFrom(item.getClass()) && ((Optional)item).isPresent();
            }

            public void describeTo(Description description) {
                description.appendText("Optional should be present");
            }
        };
    }

    public static Matcher<? super Optional<?>> isAbsent() {
        return new BaseMatcher<Optional<?>>(){

            public boolean matches(Object item) {
                return Optional.class.isAssignableFrom(item.getClass()) && !((Optional)item).isPresent();
            }

            public void describeTo(Description description) {
                description.appendText("Optional should be absent");
            }
        };
    }
}

