/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.oauth;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonDeserialize(builder=Builder.class)
public class OAuthPublicKey {
    private final String publicKey;
    private final String publicKeyFingerprint;
    private final ZonedDateTime validFrom;
    private final ZonedDateTime validUntil;

    private OAuthPublicKey(Builder builder) {
        this.publicKey = builder.publicKey;
        this.publicKeyFingerprint = builder.publicKeyFingerprint;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPublicKeyFingerprint() {
        return this.publicKeyFingerprint;
    }

    public ZonedDateTime getValidFrom() {
        return this.validFrom;
    }

    public ZonedDateTime getValidUntil() {
        return this.validUntil;
    }

    public static Builder oAuthPublicKeyBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthPublicKey that = (OAuthPublicKey)o;
        return Objects.equals(this.publicKey, that.publicKey) && Objects.equals(this.publicKeyFingerprint, that.publicKeyFingerprint) && Objects.equals(this.validFrom, that.validFrom) && Objects.equals(this.validUntil, that.validUntil);
    }

    public int hashCode() {
        return Objects.hash(this.publicKey, this.publicKeyFingerprint, this.validFrom, this.validUntil);
    }

    public String toString() {
        return "OAuthPublicKey{publicKey='" + this.publicKey + "', publicKeyFingerprint='" + this.publicKeyFingerprint + "', validFrom=" + this.validFrom + ", validUntil=" + this.validUntil + "}";
    }

    public static class Builder {
        @NotNull
        private String publicKey;
        @NotNull
        private String publicKeyFingerprint;
        private ZonedDateTime validFrom;
        private ZonedDateTime validUntil;

        public Builder withPublicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder withPublicKeyFingerprint(String publicKeyFingerprint) {
            this.publicKeyFingerprint = publicKeyFingerprint;
            return this;
        }

        public Builder withValidFrom(ZonedDateTime validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public Builder withValidUntil(ZonedDateTime validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public OAuthPublicKey build() {
            return new OAuthPublicKey(this);
        }
    }
}

