/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.oauth;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import de.otto.edison.oauth.OAuthPublicKey;
import de.otto.edison.oauth.OAuthPublicKeyRepository;
import de.otto.edison.oauth.ZonedDateTimeDeserializer;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${edison.oauth.public-key.enabled:false} && ${edison.oauth.public-key.interval:0}>0")
public class OAuthPublicKeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthPublicKeyStore.class);
    private final ObjectMapper objectMapper;
    private final String publicKeyUrl;
    private final HttpClient httpClient;
    private final OAuthPublicKeyRepository oAuthPublicKeyRepository;
    private final CountDownLatch publicKeysRetrievedCountDownLatch = new CountDownLatch(1);

    @Autowired
    public OAuthPublicKeyStore(@Value(value="${edison.oauth.public-key.url}") String publicKeyUrl, HttpClient asyncHttpClient, OAuthPublicKeyRepository oAuthPublicKeyRepository) {
        this.publicKeyUrl = publicKeyUrl;
        this.oAuthPublicKeyRepository = oAuthPublicKeyRepository;
        this.httpClient = asyncHttpClient;
        this.objectMapper = this.createObjectMapper();
    }

    public List<OAuthPublicKey> getActivePublicKeys() {
        try {
            if (this.publicKeysRetrievedCountDownLatch.await(10L, TimeUnit.SECONDS)) {
                return this.oAuthPublicKeyRepository.retrieveActivePublicKeys();
            }
            throw new RuntimeException("Timeout while waiting that public keys got fetched");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Got interrupted while waiting that public keys got fetched");
        }
    }

    @Scheduled(fixedDelayString="${edison.oauth.public-key.interval}")
    public void refreshPublicKeys() {
        LOG.info("Start refreshing public keys");
        List<OAuthPublicKey> oAuthPublicKeys = this.fetchOAuthPublicKeysFromServer();
        this.oAuthPublicKeyRepository.refreshPublicKeys(oAuthPublicKeys);
        this.publicKeysRetrievedCountDownLatch.countDown();
        LOG.info("Done refreshing public keys");
    }

    List<OAuthPublicKey> fetchOAuthPublicKeysFromServer() {
        try {
            HttpResponse<String> response = this.httpClient.send(HttpRequest.newBuilder().GET().uri(URI.create(this.publicKeyUrl)).timeout(Duration.ofMillis(5000L)).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == HttpStatus.OK.value()) {
                return (List)this.objectMapper.readValue(response.body().toString(), (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, OAuthPublicKey.class));
            }
            LOG.warn("Unable to retrieve list of public keys. Got status code {}", (Object)response.statusCode());
        }
        catch (IOException e) {
            LOG.error("Unable to retrieve list of public keys. ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return Collections.emptyList();
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper newObjectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        newObjectMapper.registerModule((Module)module);
        return newObjectMapper;
    }
}

