/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.oauth.configuration;

import de.otto.edison.oauth.KeyExchangeJwtAccessTokenConverter;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;

@Configuration
@EnableResourceServer
public class ResourceServerConfiguration
extends ResourceServerConfigurerAdapter {
    @Resource
    private KeyExchangeJwtAccessTokenConverter keyExchangeJwtAccessTokenConverter;
    @Value(value="${edison.oauth.jwt.audience}")
    private String audience;
    @Value(value="${edison.oauth.authorization.resource.patterns:/oauth2/**}")
    private String[] resourceServerUrlPatterns;

    public void configure(ResourceServerSecurityConfigurer config) {
        config.tokenServices((ResourceServerTokenServices)this.tokenServices()).resourceId(this.audience);
    }

    public void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.headers().disable()).csrf().disable()).authorizeRequests().antMatchers(this.resourceServerUrlPatterns)).authenticated();
    }

    private JwtAccessTokenConverter accessTokenConverter() {
        return this.keyExchangeJwtAccessTokenConverter;
    }

    private TokenStore tokenStore() {
        return new JwtTokenStore(this.accessTokenConverter());
    }

    private DefaultTokenServices tokenServices() {
        DefaultTokenServices defaultTokenServices = new DefaultTokenServices();
        defaultTokenServices.setTokenStore(this.tokenStore());
        return defaultTokenServices;
    }
}

