/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.oauth;

import de.otto.edison.oauth.OAuthPublicKey;
import de.otto.edison.oauth.OAuthPublicKeyStore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.RsaVerifier;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.common.util.JsonParser;
import org.springframework.security.oauth2.common.util.JsonParserFactory;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.stereotype.Component;

@Component
public class KeyExchangeJwtAccessTokenConverter
extends JwtAccessTokenConverter {
    private static final Logger LOG = LoggerFactory.getLogger(KeyExchangeJwtAccessTokenConverter.class);
    private static final JsonParser objectMapper = JsonParserFactory.create();
    private final OAuthPublicKeyStore oAuthPublicKeyStore;

    @Autowired
    public KeyExchangeJwtAccessTokenConverter(OAuthPublicKeyStore oAuthPublicKeyStore) {
        this.oAuthPublicKeyStore = oAuthPublicKeyStore;
    }

    protected Map<String, Object> decode(String token) {
        List<OAuthPublicKey> currentPublicKeys = this.oAuthPublicKeyStore.getActivePublicKeys();
        for (OAuthPublicKey publicKey : currentPublicKeys) {
            try {
                return this.decodeJwtMap(token, publicKey);
            }
            catch (Exception e) {
                LOG.debug(String.format("Unable to verify JWT token with public key: %s", publicKey.getPublicKeyFingerprint()));
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> decodeJwtMap(String token, OAuthPublicKey keyExchangePublicKey) {
        RsaVerifier rsaVerifier = new RsaVerifier(keyExchangePublicKey.getPublicKey());
        Jwt jwt = JwtHelper.decodeAndVerify((String)token, (SignatureVerifier)rsaVerifier);
        String content = jwt.getClaims();
        Map map = objectMapper.parseMap(content);
        if (map.containsKey("exp") && map.get("exp") instanceof Integer) {
            Integer intValue = (Integer)map.get("exp");
            map.put("exp", Long.valueOf(intValue.intValue()));
        }
        return map;
    }

    public void afterPropertiesSet() {
    }
}

