/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.oauth;

import de.otto.edison.oauth.OAuthPublicKey;
import de.otto.edison.oauth.OAuthPublicKeyRepository;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class OAuthPublicKeyInMemoryRepository
implements OAuthPublicKeyRepository {
    private final List<OAuthPublicKey> activePublicKeys = new ArrayList<OAuthPublicKey>();

    @Override
    public void refreshPublicKeys(List<OAuthPublicKey> publicKeys) throws IllegalArgumentException {
        Assert.isTrue((boolean)publicKeys.stream().allMatch(this::isValid), (String)"Invalid public keys retrieved");
        this.activePublicKeys.addAll(publicKeys.stream().filter(k -> !this.activePublicKeys.contains(k)).collect(Collectors.toList()));
    }

    private boolean isValid(OAuthPublicKey publicKey) {
        ZonedDateTime now = ZonedDateTime.now();
        return now.isAfter(publicKey.getValidFrom()) && (Objects.isNull(publicKey.getValidUntil()) || now.isBefore(publicKey.getValidUntil()));
    }

    @Override
    public List<OAuthPublicKey> retrieveActivePublicKeys() {
        return this.activePublicKeys.stream().filter(this::isValid).collect(Collectors.toList());
    }
}

