/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.oauth;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.otto.edison.oauth.OAuthPublicKey;
import de.otto.edison.oauth.OAuthPublicKeyRepository;
import de.otto.edison.oauth.ZonedDateTimeDeserializer;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${edison.oauth.public-key.enabled:false} && ${edison.oauth.public-key.interval:0}>0")
public class OAuthPublicKeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthPublicKeyStore.class);
    private final ObjectMapper objectMapper;
    private final String publicKeyUrl;
    private final AsyncHttpClient asyncHttpClient;
    private final OAuthPublicKeyRepository oAuthPublicKeyRepository;

    @Autowired
    public OAuthPublicKeyStore(@Value(value="${edison.oauth.public-key.url}") String publicKeyUrl, AsyncHttpClient asyncHttpClient, OAuthPublicKeyRepository oAuthPublicKeyRepository) {
        this.publicKeyUrl = publicKeyUrl;
        this.oAuthPublicKeyRepository = oAuthPublicKeyRepository;
        this.asyncHttpClient = asyncHttpClient;
        this.objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        this.objectMapper.registerModule((Module)module);
    }

    @Scheduled(fixedDelayString="${edison.oauth.public-key.interval}")
    public void retrieveApiOauthPublicKey() {
        block6: {
            try {
                Response response = (Response)((BoundRequestBuilder)this.asyncHttpClient.prepareGet(this.publicKeyUrl).setRequestTimeout(5000)).execute().get();
                if (response.getStatusCode() == HttpStatus.OK.value()) {
                    try {
                        OAuthPublicKey[] retrievedPublicKeys = (OAuthPublicKey[])this.objectMapper.readValue(response.getResponseBody(), OAuthPublicKey[].class);
                        List<OAuthPublicKey> activePublicKeys = this.filterActivePublicKeys(retrievedPublicKeys);
                        if (activePublicKeys.isEmpty()) {
                            LOG.error(String.format("Did not retrieve valid OAuthPublicKeys from %s", this.publicKeyUrl));
                            break block6;
                        }
                        this.oAuthPublicKeyRepository.refreshPublicKeys(activePublicKeys);
                        LOG.info(String.format("Successfully retrieved %d public keys with the following finger prints: %s", activePublicKeys.size(), activePublicKeys.stream().map(OAuthPublicKey::getPublicKeyFingerprint).collect(Collectors.toList())));
                    }
                    catch (IOException ex) {
                        LOG.error(String.format("Unable to parse PublicKeys from OAuth-Server-Response: %s", ex.getMessage()), (Throwable)ex);
                    }
                    break block6;
                }
                LOG.error(String.format("Unable to retrieve list of public keys. Status was %d", response.getStatusCode()));
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.error("Unable to retrieve list of public keys.", (Throwable)ex);
            }
        }
    }

    private List<OAuthPublicKey> filterActivePublicKeys(OAuthPublicKey[] publicKeys) {
        return Arrays.stream(publicKeys).filter(this::isValid).collect(Collectors.toList());
    }

    private boolean isValid(OAuthPublicKey publicKey) {
        ZonedDateTime now = ZonedDateTime.now();
        return now.isAfter(publicKey.getValidFrom()) && (Objects.isNull(publicKey.getValidUntil()) || now.isBefore(publicKey.getValidUntil()));
    }
}

