/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.repository.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Updates;
import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.domain.JobMessage;
import de.otto.edison.jobs.domain.Level;
import de.otto.edison.jobs.domain.RunningJobs;
import de.otto.edison.jobs.repository.JobBlockedException;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.jobs.repository.mongo.DateTimeConverters;
import de.otto.edison.jobs.repository.mongo.JobStructure;
import de.otto.edison.mongo.AbstractMongoRepository;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="jobRepository")
public class MongoJobRepository
extends AbstractMongoRepository<String, JobInfo>
implements JobRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MongoJobRepository.class);
    private static final String JOB_INFO_COLLECTION_NAME = "jobinfo";
    private static final String JOBS_META_DATA_COLLECTION_NAME = "jobmetadata";
    private static final String RUNNING_JOBS_DOCUMENT = "RUNNING_JOBS";
    private static final String DISABLED_JOBS_DOCUMENT = "DISABLED_JOBS";
    private static final int DESCENDING = -1;
    private static final String NO_LOG_MESSAGE_FOUND = "No log message found";
    public static final String ID = "_id";
    private final MongoCollection<Document> jobInfoCollection;
    private final MongoCollection<Document> runningJobsCollection;
    private final Clock clock;

    @Autowired
    public MongoJobRepository(MongoDatabase database) {
        this.jobInfoCollection = database.getCollection(JOB_INFO_COLLECTION_NAME);
        this.runningJobsCollection = database.getCollection(JOBS_META_DATA_COLLECTION_NAME);
        this.clock = Clock.systemDefaultZone();
    }

    @PostConstruct
    public void initJobsMetaDataDocumentsOnStartup() {
        if (this.runningJobsCollection.count(Filters.eq((String)ID, (Object)RUNNING_JOBS_DOCUMENT)) == 0L) {
            this.runningJobsCollection.insertOne((Object)new Document(ID, (Object)RUNNING_JOBS_DOCUMENT));
        }
        if (this.runningJobsCollection.count(Filters.eq((String)ID, (Object)DISABLED_JOBS_DOCUMENT)) == 0L) {
            this.runningJobsCollection.insertOne((Object)new Document(ID, (Object)DISABLED_JOBS_DOCUMENT));
        }
    }

    public JobInfo.JobStatus findStatus(String jobId) {
        return JobInfo.JobStatus.valueOf((String)((Document)this.collection().find(Filters.eq((String)ID, (Object)jobId)).projection((Bson)new Document(JobStructure.STATUS.key(), (Object)true)).first()).getString((Object)JobStructure.STATUS.key()));
    }

    public void removeIfStopped(String id) {
        this.findOne(id).ifPresent(jobInfo -> {
            if (jobInfo.isStopped()) {
                this.collection().deleteOne(Filters.eq((String)ID, (Object)id));
            }
        });
    }

    public void appendMessage(String jobId, JobMessage jobMessage) {
        this.collection().updateOne(Filters.eq((String)ID, (Object)jobId), Updates.push((String)JobStructure.MESSAGES.key(), (Object)MongoJobRepository.encodeJobMessage(jobMessage)));
    }

    public void setJobStatus(String jobId, JobInfo.JobStatus jobStatus) {
        this.collection().updateOne(Filters.eq((String)ID, (Object)jobId), Updates.set((String)JobStructure.STATUS.key(), (Object)jobStatus.name()));
    }

    public void setLastUpdate(String jobId, OffsetDateTime lastUpdate) {
        this.collection().updateOne(Filters.eq((String)ID, (Object)jobId), Updates.set((String)JobStructure.LAST_UPDATED.key(), (Object)DateTimeConverters.toDate(lastUpdate)));
    }

    public void markJobAsRunningIfPossible(JobInfo jobInfo, Set<String> blockingJobTypes) throws JobBlockedException {
        Bson disabledJobsFilter = Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)DISABLED_JOBS_DOCUMENT), Filters.exists((String)jobInfo.getJobType())});
        if (this.runningJobsCollection.find(disabledJobsFilter).first() != null) {
            throw new JobBlockedException("Disabled");
        }
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)ID, (Object)RUNNING_JOBS_DOCUMENT), Filters.and((Iterable)blockingJobTypes.stream().map(type -> Filters.not((Bson)Filters.exists((String)type))).collect(Collectors.toList()))});
        Document updatedRunningJobsDocument = (Document)this.runningJobsCollection.findOneAndUpdate(query, Updates.set((String)jobInfo.getJobType(), (Object)jobInfo.getJobId()));
        if (updatedRunningJobsDocument == null) {
            throw new JobBlockedException("job blocked by other '" + jobInfo.getJobType() + "' job");
        }
    }

    public void clearRunningMark(String jobType) {
        Bson query = Filters.eq((String)ID, (Object)RUNNING_JOBS_DOCUMENT);
        Document updateResult = (Document)this.runningJobsCollection.findOneAndUpdate(query, Updates.unset((String)jobType));
        if (updateResult == null) {
            LOG.warn("Could not clear running Mark for Job {}", (Object)jobType);
        }
    }

    public RunningJobs runningJobsDocument() {
        Document runningJobsDocument = (Document)this.runningJobsCollection.find(Filters.eq((String)ID, (Object)RUNNING_JOBS_DOCUMENT)).first();
        if (runningJobsDocument == null) {
            return new RunningJobs(Collections.emptyList());
        }
        List runningJobs = runningJobsDocument.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(ID)).map(entry -> new RunningJobs.RunningJob(entry.getValue().toString(), (String)entry.getKey())).collect(Collectors.toList());
        return new RunningJobs(runningJobs);
    }

    public void disableJobType(String jobType) {
        this.runningJobsCollection.findOneAndUpdate(Filters.eq((String)ID, (Object)DISABLED_JOBS_DOCUMENT), Updates.set((String)jobType, (Object)"disabled"), new FindOneAndUpdateOptions().upsert(true));
    }

    public void enableJobType(String jobType) {
        this.runningJobsCollection.findOneAndUpdate(Filters.eq((String)ID, (Object)DISABLED_JOBS_DOCUMENT), Updates.unset((String)jobType), new FindOneAndUpdateOptions().upsert(true));
    }

    public List<String> findDisabledJobTypes() {
        Document disabledJobsDocument = (Document)this.runningJobsCollection.find(Filters.eq((String)ID, (Object)DISABLED_JOBS_DOCUMENT)).first();
        return disabledJobsDocument.keySet().stream().filter(k -> !k.equals(ID)).collect(Collectors.toList());
    }

    public List<JobInfo> findLatest(int maxCount) {
        return (List)this.collection().find().sort((Bson)this.orderByStarted(-1)).limit(maxCount).map(this::decode).into(new ArrayList());
    }

    public List<JobInfo> findLatestJobsDistinct() {
        List<String> allJobIds = this.findAllJobIdsDistinct();
        return (List)this.collection().find(Filters.in((String)ID, allJobIds)).map(this::decode).into(new ArrayList());
    }

    public List<String> findAllJobIdsDistinct() {
        return ((ArrayList)this.collection().aggregate(Arrays.asList(new Document("$sort", (Object)new Document("started", (Object)-1)), new Document("$group", (Object)new HashMap<String, Object>(){
            {
                this.put(MongoJobRepository.ID, "$type");
                this.put("latestJobId", new Document("$first", (Object)"$_id"));
            }
        }))).map(doc -> doc.getString((Object)"latestJobId")).into(new ArrayList())).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<JobInfo> findLatestBy(String type, int maxCount) {
        return (List)this.collection().find((Bson)this.byType(type)).sort((Bson)this.orderByStarted(-1)).limit(maxCount).map(this::decode).into(new ArrayList());
    }

    public List<JobInfo> findByType(String type) {
        return (List)this.collection().find((Bson)this.byType(type)).sort((Bson)this.orderByStarted(-1)).map(this::decode).into(new ArrayList());
    }

    public List<JobInfo> findRunningWithoutUpdateSince(OffsetDateTime timeOffset) {
        return (List)this.collection().find((Bson)new Document().append(JobStructure.STOPPED.key(), Collections.singletonMap("$exists", false)).append(JobStructure.LAST_UPDATED.key(), Collections.singletonMap("$lt", Date.from(timeOffset.toInstant())))).map(this::decode).into(new ArrayList());
    }

    protected final Document encode(JobInfo job) {
        Document document = new Document().append(JobStructure.ID.key(), (Object)job.getJobId()).append(JobStructure.JOB_TYPE.key(), (Object)job.getJobType()).append(JobStructure.STARTED.key(), (Object)DateTimeConverters.toDate(job.getStarted())).append(JobStructure.LAST_UPDATED.key(), (Object)DateTimeConverters.toDate(job.getLastUpdated())).append(JobStructure.MESSAGES.key(), job.getMessages().stream().map(MongoJobRepository::encodeJobMessage).collect(Collectors.toList())).append(JobStructure.STATUS.key(), (Object)job.getStatus().name()).append(JobStructure.HOSTNAME.key(), (Object)job.getHostname());
        if (job.isStopped()) {
            document.append(JobStructure.STOPPED.key(), (Object)DateTimeConverters.toDate((OffsetDateTime)job.getStopped().get()));
        }
        return document;
    }

    private static Document encodeJobMessage(final JobMessage jm) {
        return new Document(){
            {
                this.put(JobStructure.MSG_LEVEL.key(), jm.getLevel().name());
                this.put(JobStructure.MSG_TS.key(), DateTimeConverters.toDate(jm.getTimestamp()));
                this.put(JobStructure.MSG_TEXT.key(), jm.getMessage());
            }
        };
    }

    protected final JobInfo decode(Document document) {
        return JobInfo.newJobInfo((String)document.getString((Object)JobStructure.ID.key()), (String)document.getString((Object)JobStructure.JOB_TYPE.key()), (OffsetDateTime)DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobStructure.STARTED.key())), (OffsetDateTime)DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobStructure.LAST_UPDATED.key())), Optional.ofNullable(DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobStructure.STOPPED.key()))), (JobInfo.JobStatus)JobInfo.JobStatus.valueOf((String)document.getString((Object)JobStructure.STATUS.key())), this.getMessagesFrom(document), (Clock)this.clock, (String)document.getString((Object)JobStructure.HOSTNAME.key()));
    }

    private List<JobMessage> getMessagesFrom(Document document) {
        List messages = (List)document.get((Object)JobStructure.MESSAGES.key());
        if (messages != null) {
            return messages.stream().map(this::toJobMessage).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private JobMessage toJobMessage(Document document) {
        return JobMessage.jobMessage((Level)Level.valueOf((String)document.get((Object)JobStructure.MSG_LEVEL.key()).toString()), (String)this.getMessage(document), (OffsetDateTime)DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobStructure.MSG_TS.key())));
    }

    protected final String keyOf(JobInfo value) {
        return value.getJobId();
    }

    protected final MongoCollection<Document> collection() {
        return this.jobInfoCollection;
    }

    protected final void ensureIndexes() {
        this.collection().createIndex((Bson)new BasicDBObject(JobStructure.JOB_TYPE.key(), (Object)1));
        this.collection().createIndex((Bson)new BasicDBObject(JobStructure.STARTED.key(), (Object)1));
    }

    private String getMessage(Document document) {
        return document.get((Object)JobStructure.MSG_TEXT.key()) == null ? NO_LOG_MESSAGE_FOUND : document.get((Object)JobStructure.MSG_TEXT.key()).toString();
    }

    private Document byType(String type) {
        return new Document(JobStructure.JOB_TYPE.key(), (Object)type);
    }

    private Document byTypeAndStatus(String type, JobInfo.JobStatus status) {
        return new Document(JobStructure.JOB_TYPE.key(), (Object)type).append(JobStructure.STATUS.key(), (Object)status.name());
    }

    private Document orderByStarted(int order) {
        return new Document(JobStructure.STARTED.key(), (Object)order);
    }

    public List<JobInfo> findAllJobInfoWithoutMessages() {
        return (List)this.collection().find().projection((Bson)new Document(this.getJobInfoWithoutMessagesProjection())).map(this::decode).into(new ArrayList());
    }

    private Map<String, Object> getJobInfoWithoutMessagesProjection() {
        HashMap<String, Object> projection = new HashMap<String, Object>();
        projection.put(JobStructure.ID.key(), true);
        projection.put(JobStructure.JOB_TYPE.key(), true);
        projection.put(JobStructure.STARTED.key(), true);
        projection.put(JobStructure.LAST_UPDATED.key(), true);
        projection.put(JobStructure.STOPPED.key(), true);
        projection.put(JobStructure.STATUS.key(), true);
        projection.put(JobStructure.HOSTNAME.key(), true);
        return projection;
    }
}

