/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.repository.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import de.otto.edison.jobs.repository.mongo.DateTimeConverters;
import de.otto.edison.jobs.repository.mongo.JobRunLock;
import de.otto.edison.jobs.repository.mongo.JobRunLockStructure;
import de.otto.edison.mongo.AbstractMongoRepository;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="jobRunLockRepository")
public class MongoJobRunLockRepository
extends AbstractMongoRepository<String, JobRunLock> {
    private static final String COLLECTION_NAME = "jobRunLocks";
    private final MongoCollection<Document> collection;

    @Autowired
    public MongoJobRunLockRepository(MongoDatabase database) {
        this.collection = database.getCollection(COLLECTION_NAME);
    }

    protected void ensureIndexes() {
    }

    protected MongoCollection<Document> collection() {
        return this.collection;
    }

    protected String keyOf(JobRunLock value) {
        return value.getId();
    }

    protected Document encode(JobRunLock value) {
        return new Document().append(JobRunLockStructure.ID.key(), (Object)value.getId()).append(JobRunLockStructure.CREATED.key(), (Object)DateTimeConverters.toDate(value.getCreated()));
    }

    protected JobRunLock decode(Document document) {
        return new JobRunLock(document.getString((Object)JobRunLockStructure.ID.key()), DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobRunLockStructure.CREATED.key())));
    }
}

