/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.jobs.repository.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.domain.JobMessage;
import de.otto.edison.jobs.domain.Level;
import de.otto.edison.jobs.repository.JobRepository;
import de.otto.edison.jobs.repository.mongo.DateTimeConverters;
import de.otto.edison.jobs.repository.mongo.JobStructure;
import de.otto.edison.mongo.AbstractMongoRepository;
import java.net.URI;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="jobRepository")
public class MongoJobRepository
extends AbstractMongoRepository<URI, JobInfo>
implements JobRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MongoJobRepository.class);
    private static final int DESCENDING = -1;
    private static final String COLLECTION_NAME = "jobinfo";
    public static final String NO_LOG_MESSAGE_FOUND = "No log message found";
    private final MongoCollection<Document> collection;
    private final Clock clock;

    @Autowired
    public MongoJobRepository(MongoDatabase database) {
        this.collection = database.getCollection(COLLECTION_NAME);
        this.clock = Clock.systemDefaultZone();
    }

    MongoJobRepository(MongoDatabase database, Clock clock) {
        this.collection = database.getCollection(COLLECTION_NAME);
        this.clock = clock;
    }

    public void removeIfStopped(URI uri) {
        this.findOne(uri).ifPresent(jobInfo -> {
            if (jobInfo.isStopped()) {
                this.collection().deleteOne((Bson)this.byId(uri));
            }
        });
    }

    public JobInfo.JobStatus findStatus(URI jobUri) {
        return JobInfo.JobStatus.valueOf((String)((Document)this.collection().find((Bson)this.byId(jobUri)).projection((Bson)new Document(JobStructure.STATUS.key(), (Object)true)).first()).getString((Object)JobStructure.STATUS.key()));
    }

    public void appendMessage(URI jobUri, JobMessage jobMessage) {
        Document document = new Document("$push", (Object)new Document(JobStructure.MESSAGES.key(), (Object)MongoJobRepository.encodeJobMessage(jobMessage)));
        this.collection().updateOne((Bson)this.byId(jobUri), (Bson)document);
    }

    public List<JobInfo> findLatest(int maxCount) {
        return (List)this.collection().find().sort((Bson)this.orderByStarted(-1)).limit(maxCount).map(this::decode).into(new ArrayList());
    }

    public List<JobInfo> findLatestBy(String type, int maxCount) {
        return (List)this.collection().find((Bson)this.byType(type)).sort((Bson)this.orderByStarted(-1)).limit(maxCount).map(this::decode).into(new ArrayList());
    }

    public List<JobInfo> findLatestFinishedBy(String type, JobInfo.JobStatus status, int maxCount) {
        return (List)this.collection().find((Bson)this.byTypeAndStatus(type, status).append(JobStructure.STOPPED.key(), Collections.singletonMap("$exists", true))).sort((Bson)this.orderByStarted(-1)).limit(maxCount).map(this::decode).into(new ArrayList());
    }

    public List<JobInfo> findByType(String type) {
        return (List)this.collection().find((Bson)this.byType(type)).sort((Bson)this.orderByStarted(-1)).map(this::decode).into(new ArrayList());
    }

    public List<JobInfo> findRunningWithoutUpdateSince(OffsetDateTime timeOffset) {
        return (List)this.collection().find((Bson)new Document().append(JobStructure.STOPPED.key(), Collections.singletonMap("$exists", false)).append(JobStructure.LAST_UPDATED.key(), Collections.singletonMap("$lt", Date.from(timeOffset.toInstant())))).map(this::decode).into(new ArrayList());
    }

    public Optional<JobInfo> findRunningJobByType(String jobType) {
        return Optional.ofNullable(this.collection().find((Bson)new Document().append(JobStructure.STOPPED.key(), Collections.singletonMap("$exists", false)).append(JobStructure.JOB_TYPE.key(), (Object)jobType)).limit(1).map(this::decode).first());
    }

    protected final Document encode(JobInfo job) {
        Document document = new Document().append(JobStructure.ID.key(), (Object)job.getJobUri().toString()).append(JobStructure.JOB_TYPE.key(), (Object)job.getJobType()).append(JobStructure.STARTED.key(), (Object)DateTimeConverters.toDate(job.getStarted())).append(JobStructure.LAST_UPDATED.key(), (Object)DateTimeConverters.toDate(job.getLastUpdated())).append(JobStructure.MESSAGES.key(), job.getMessages().stream().map(MongoJobRepository::encodeJobMessage).collect(Collectors.toList())).append(JobStructure.STATUS.key(), (Object)job.getStatus().name()).append(JobStructure.HOSTNAME.key(), (Object)job.getHostname());
        if (job.isStopped()) {
            document.append(JobStructure.STOPPED.key(), (Object)DateTimeConverters.toDate((OffsetDateTime)job.getStopped().get()));
        }
        return document;
    }

    private static Document encodeJobMessage(final JobMessage jm) {
        return new Document(){
            {
                this.put(JobStructure.MSG_LEVEL.key(), jm.getLevel().name());
                this.put(JobStructure.MSG_TS.key(), DateTimeConverters.toDate(jm.getTimestamp()));
                this.put(JobStructure.MSG_TEXT.key(), jm.getMessage());
            }
        };
    }

    protected final JobInfo decode(Document document) {
        return JobInfo.newJobInfo((URI)URI.create(document.getString((Object)JobStructure.ID.key())), (String)document.getString((Object)JobStructure.JOB_TYPE.key()), (OffsetDateTime)DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobStructure.STARTED.key())), (OffsetDateTime)DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobStructure.LAST_UPDATED.key())), Optional.ofNullable(DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobStructure.STOPPED.key()))), (JobInfo.JobStatus)JobInfo.JobStatus.valueOf((String)document.getString((Object)JobStructure.STATUS.key())), this.getMessagesFrom(document), (Clock)this.clock, (String)document.getString((Object)JobStructure.HOSTNAME.key()));
    }

    private List<JobMessage> getMessagesFrom(Document document) {
        List messages = (List)document.get((Object)JobStructure.MESSAGES.key());
        if (messages != null) {
            return messages.stream().map(this::toJobMessage).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private JobMessage toJobMessage(Document document) {
        return JobMessage.jobMessage((Level)Level.valueOf((String)document.get((Object)JobStructure.MSG_LEVEL.key()).toString()), (String)this.getMessage(document), (OffsetDateTime)DateTimeConverters.toOffsetDateTime(document.getDate((Object)JobStructure.MSG_TS.key())));
    }

    protected final URI keyOf(JobInfo value) {
        return value.getJobUri();
    }

    protected final MongoCollection<Document> collection() {
        return this.collection;
    }

    protected final void ensureIndexes() {
        this.collection().createIndex((Bson)new BasicDBObject(JobStructure.JOB_TYPE.key(), (Object)1));
        this.collection().createIndex((Bson)new BasicDBObject(JobStructure.STARTED.key(), (Object)1));
    }

    private String getMessage(Document document) {
        return document.get((Object)JobStructure.MSG_TEXT.key()) == null ? NO_LOG_MESSAGE_FOUND : document.get((Object)JobStructure.MSG_TEXT.key()).toString();
    }

    private Document byType(String type) {
        return new Document(JobStructure.JOB_TYPE.key(), (Object)type);
    }

    private Document byTypeAndStatus(String type, JobInfo.JobStatus status) {
        return new Document(JobStructure.JOB_TYPE.key(), (Object)type).append(JobStructure.STATUS.key(), (Object)status.name());
    }

    private Document orderByStarted(int order) {
        return new Document(JobStructure.STARTED.key(), (Object)order);
    }
}

