/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.aws.s3.togglz;

import de.otto.edison.aws.s3.togglz.FeatureStateConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class S3TogglzRepository
implements StateRepository {
    private static final Logger LOG = LoggerFactory.getLogger(S3TogglzRepository.class);
    private static final int SCHEDULE_RATE_IN_MILLISECONDS = 60000;
    private final Map<Feature, CacheEntry> cache = new ConcurrentHashMap<Feature, CacheEntry>();
    private final FeatureStateConverter featureStateConverter;

    public S3TogglzRepository(FeatureStateConverter featureStateConverter) {
        this.featureStateConverter = featureStateConverter;
    }

    public FeatureState getFeatureState(Feature feature) {
        CacheEntry cachedEntry = this.cache.get(feature);
        if (cachedEntry != null) {
            return cachedEntry.getState();
        }
        FeatureState featureState = this.featureStateConverter.retrieveFeatureStateFromS3(feature);
        this.cache.put(feature, new CacheEntry(featureState));
        return featureState;
    }

    public void setFeatureState(FeatureState featureState) {
        this.featureStateConverter.persistFeatureStateToS3(featureState);
        this.cache.put(featureState.getFeature(), new CacheEntry(featureState));
    }

    @Scheduled(initialDelay=0L, fixedRate=60000L)
    private void prefetchFeatureStates() {
        if (this.cache.size() == 0) {
            LOG.debug("Initialize state for features");
            this.initializeFeatureStates();
        } else {
            LOG.debug("Refreshing state for features");
            this.cache.replaceAll((feature, cacheEntry) -> new CacheEntry(this.featureStateConverter.retrieveFeatureStateFromS3((Feature)feature)));
        }
    }

    private void initializeFeatureStates() {
        try {
            FeatureContext.getFeatureManager().getFeatures().forEach(this::getFeatureState);
        }
        catch (Exception ex) {
            LOG.error("Unable to Initialize feature states", (Throwable)ex);
        }
    }

    private static class CacheEntry {
        private final FeatureState state;

        public CacheEntry(FeatureState state) {
            this.state = state;
        }

        public FeatureState getState() {
            return this.state;
        }
    }
}

