/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.aws.s3.togglz;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.edison.aws.s3.togglz.S3TogglzProperties;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.FeatureStateStorageWrapper;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

@Component
public class FeatureStateConverter {
    private static final String ERR_NO_SUCH_KEY = "NoSuchKey";
    private final S3Client s3Client;
    private final S3TogglzProperties s3TogglzProperties;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public FeatureStateConverter(S3Client s3Client, S3TogglzProperties s3TogglzProperties) {
        this.s3Client = s3Client;
        this.s3TogglzProperties = s3TogglzProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeatureState retrieveFeatureStateFromS3(Feature feature) {
        GetObjectRequest getRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.s3TogglzProperties.getBucketName()).key(this.keyForFeature(feature)).build();
        try (ResponseInputStream responseStream = this.s3Client.getObject(getRequest);){
            if (responseStream == null) return null;
            FeatureStateStorageWrapper wrapper = (FeatureStateStorageWrapper)objectMapper.reader().forType(FeatureStateStorageWrapper.class).readValue((InputStream)responseStream);
            FeatureState featureState = FeatureStateStorageWrapper.featureStateForWrapper((Feature)feature, (FeatureStateStorageWrapper)wrapper);
            return featureState;
        }
        catch (S3Exception ae) {
            if (!ERR_NO_SUCH_KEY.equals(ae.awsErrorDetails().errorCode())) throw ae;
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get the feature state", e);
        }
    }

    public void persistFeatureStateToS3(FeatureState featureState) {
        try {
            FeatureStateStorageWrapper storageWrapper = FeatureStateStorageWrapper.wrapperForFeatureState((FeatureState)featureState);
            String json = objectMapper.writeValueAsString((Object)storageWrapper);
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.s3TogglzProperties.getBucketName()).key(this.keyForFeature(featureState.getFeature())).serverSideEncryption(ServerSideEncryption.AES256).build();
            RequestBody requestBody = RequestBody.fromString((String)json);
            this.s3Client.putObject(putObjectRequest, requestBody);
        }
        catch (JsonProcessingException | S3Exception e) {
            throw new RuntimeException("Failed to set the feature state", e);
        }
    }

    private String keyForFeature(Feature feature) {
        return this.s3TogglzProperties.getKeyPrefix() + feature.name();
    }
}

