/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.aws.s3;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3Service {
    private static final Logger LOG = LoggerFactory.getLogger(S3Service.class);
    private final S3Client s3Client;

    public S3Service(S3Client s3Client) {
        this.s3Client = s3Client;
    }

    public void createBucket(String bucketName) {
        if (!this.listBucketNames().contains(bucketName)) {
            this.s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build());
        }
    }

    public List<String> listBucketNames() {
        return this.s3Client.listBuckets().buckets().stream().map(Bucket::name).collect(Collectors.toList());
    }

    public void upload(String bucketName, File file) {
        PutObjectResponse putObjectResponse = this.s3Client.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(file.getName()).build(), file.toPath());
        LOG.debug("upload {} to bucket {}: ", new Object[]{file.getName(), bucketName, putObjectResponse.toString()});
    }

    public boolean download(String bucketName, String fileName, Path destination) {
        try {
            if (Files.exists(destination, new LinkOption[0])) {
                Files.delete(destination);
            }
        }
        catch (IOException e) {
            LOG.error("could not delete temp snapshotfile {}", (Object)destination.toString(), (Object)e);
            return false;
        }
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(fileName).build();
        GetObjectResponse getObjectResponse = this.s3Client.getObject(request, destination);
        LOG.debug("download {} from bucket {}: ", new Object[]{fileName, bucketName, getObjectResponse.toString()});
        return true;
    }

    public void deleteAllObjectsInBucket(String bucketName) {
        LOG.debug("deleting all objects in bucket {}", (Object)bucketName);
        this.deleteAllObjectsWithPrefixInBucket(bucketName, "");
        LOG.debug("files in bucket: {}", this.listAllFiles(bucketName));
    }

    public void deleteAllObjectsWithPrefixInBucket(String bucketName, String prefix) {
        ListObjectsV2Response listObjectResponse = this.s3Client.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).build());
        if (listObjectResponse.keyCount() > 0) {
            DeleteObjectsRequest deleteObjectsRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(this.convertS3ObjectsToObjectIdentifiers(listObjectResponse, prefix)).build()).build();
            DeleteObjectsResponse deleteObjectsResponse = this.s3Client.deleteObjects(deleteObjectsRequest);
            LOG.debug("deleteAllObjectsWithPrefixInBucket in bucket {} with prefix {}: {}", new Object[]{bucketName, prefix, deleteObjectsResponse});
        } else {
            LOG.debug("deleteAllObjectsWithPrefixInBucket listObjects found no keys in bucket {} with prefix {}: {}", new Object[]{bucketName, prefix, listObjectResponse});
        }
    }

    public List<String> listAllFiles(String bucketName) {
        return this.listAll(bucketName).stream().map(S3Object::key).collect(Collectors.toList());
    }

    public List<S3Object> listAll(String bucketName) {
        ListObjectsV2Response listObjectsV2Response = this.s3Client.listObjectsV2((ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).build());
        if (listObjectsV2Response.keyCount() > 0) {
            return listObjectsV2Response.contents();
        }
        return Collections.emptyList();
    }

    private List<ObjectIdentifier> convertS3ObjectsToObjectIdentifiers(ListObjectsV2Response listObjectsV2Response, String prefix) {
        return listObjectsV2Response.contents().stream().filter(o -> o.key() != null && o.key().startsWith(prefix)).map(o -> (ObjectIdentifier)ObjectIdentifier.builder().key(o.key()).build()).collect(Collectors.toList());
    }
}

