/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.aws.paramstore;

import de.otto.edison.aws.configuration.AwsConfiguration;
import de.otto.edison.aws.configuration.AwsProperties;
import de.otto.edison.aws.paramstore.ParamStoreProperties;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.Parameter;
import software.amazon.awssdk.services.ssm.model.ParameterType;

@Component
@ConditionalOnProperty(name={"edison.aws.config.paramstore.enabled"}, havingValue="true")
public class ParamStorePropertySourcePostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(ParamStorePropertySourcePostProcessor.class);
    private static final String PARAMETER_STORE_PROPERTY_SOURCE = "parameterStorePropertySource";
    private SsmClient ssmClient;
    private ParamStoreProperties properties;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Properties propertiesSource = new Properties();
        GetParametersByPathRequest.Builder requestBuilder = GetParametersByPathRequest.builder().path(this.properties.getPath()).recursive(Boolean.valueOf(true)).withDecryption(Boolean.valueOf(true));
        GetParametersByPathResponse firstPage = this.ssmClient.getParametersByPath((GetParametersByPathRequest)requestBuilder.build());
        this.addParametersToPropertiesSource(propertiesSource, firstPage.parameters());
        String nextToken = firstPage.nextToken();
        while (!StringUtil.isNullOrEmpty((String)nextToken)) {
            GetParametersByPathResponse nextPage = this.ssmClient.getParametersByPath((GetParametersByPathRequest)requestBuilder.nextToken(nextToken).build());
            this.addParametersToPropertiesSource(propertiesSource, nextPage.parameters());
            nextToken = nextPage.nextToken();
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        MutablePropertySources propertySources = env.getPropertySources();
        if (this.properties.isAddWithLowestPrecedence()) {
            propertySources.addLast((PropertySource)new PropertiesPropertySource(PARAMETER_STORE_PROPERTY_SOURCE, propertiesSource));
        } else {
            propertySources.addFirst((PropertySource)new PropertiesPropertySource(PARAMETER_STORE_PROPERTY_SOURCE, propertiesSource));
        }
    }

    private void addParametersToPropertiesSource(Properties propertiesSource, List<Parameter> parameters) {
        parameters.forEach(p -> {
            String name = p.name().substring(this.properties.getPath().length() + 1);
            String loggingValue = ParameterType.SECURE_STRING == p.type() ? "*****" : p.value();
            LOG.info("Loaded '" + name + "' from ParametersStore, value='" + loggingValue + "', length=" + p.value().length());
            propertiesSource.setProperty(name, p.value());
        });
    }

    public void setEnvironment(Environment environment) {
        String pathProperty = "edison.aws.config.paramstore.path";
        String path = Objects.requireNonNull(environment.getProperty("edison.aws.config.paramstore.path"), "Property 'edison.aws.config.paramstore.path' must not be null");
        this.properties = new ParamStoreProperties();
        this.properties.setAddWithLowestPrecedence(Boolean.parseBoolean(environment.getProperty("edison.aws.config.paramstore.addWithLowestPrecedence", "false")));
        this.properties.setPath(path);
        AwsProperties awsProperties = new AwsProperties();
        awsProperties.setProfile(environment.getProperty("aws.profile", "default"));
        awsProperties.setRegion(environment.getProperty("aws.region", Region.EU_CENTRAL_1.id()));
        AwsConfiguration awsConfig = new AwsConfiguration();
        this.ssmClient = (SsmClient)((SsmClientBuilder)SsmClient.builder().credentialsProvider(awsConfig.awsCredentialsProvider(awsProperties))).build();
    }
}

