/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.metrics.cloudwatch;

import de.otto.edison.metrics.cloudwatch.CloudWatchMetricFilter;
import io.micrometer.cloudwatch2.CloudWatchConfig;
import io.micrometer.cloudwatch2.CloudWatchMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;

public class FilteredCloudWatchMeterRegistry
extends CloudWatchMeterRegistry {
    public static final String CLOUDWATCH_METRICS_PUBLISHER = "cloudwatch-metrics-publisher";
    final CloudWatchMetricFilter cloudWatchMetricFilter;

    public FilteredCloudWatchMeterRegistry(CloudWatchMetricFilter cloudWatchMetricFilter, CloudWatchConfig config, Clock clock, CloudWatchAsyncClient cloudWatchAsyncClient) {
        super(config, clock, cloudWatchAsyncClient, (ThreadFactory)new NamedThreadFactory(CLOUDWATCH_METRICS_PUBLISHER));
        this.cloudWatchMetricFilter = cloudWatchMetricFilter;
    }

    public List<Meter> getMeters() {
        List meters = super.getMeters();
        if (Objects.equals(Thread.currentThread().getName(), CLOUDWATCH_METRICS_PUBLISHER)) {
            return this.cloudWatchMetricFilter.filter(meters);
        }
        return meters;
    }
}

