/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.metrics.cloudwatch;

import com.google.common.collect.Streams;
import de.otto.edison.metrics.cloudwatch.CloudWatchMetricsProperties;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.internal.DefaultMeter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;

public class CloudWatchMetricFilter {
    private final List<String> allowedMetrics;
    private final Map<String, String> dimensions;

    public CloudWatchMetricFilter(CloudWatchMetricsProperties cloudWatchMetricsProperties) {
        this.allowedMetrics = cloudWatchMetricsProperties.getAllowedmetrics();
        this.dimensions = cloudWatchMetricsProperties.getDimensions();
    }

    public List<Meter> filter(List<Meter> meters) {
        return meters.stream().map(e -> this.filter((Meter)e)).filter((? super T e) -> Objects.nonNull(e)).collect(Collectors.toList());
    }

    protected Meter filter(Meter meter) {
        if (this.matchMetric(meter.getId())) {
            return new DefaultMeter(this.mapMetric(meter.getId()), meter.getId().getType(), meter.measure());
        }
        return null;
    }

    private List<Measurement> getDefaultMeasurementWithoutStatistic(Meter meter) {
        return Streams.stream((Iterable)meter.measure()).map(e -> new Measurement(() -> e.getValue(), null)).collect(Collectors.toList());
    }

    private void registerFilter(MeterRegistry meterRegistry) {
        MeterRegistry.Config config = meterRegistry.config();
        config.meterFilter(MeterFilter.denyUnless(m -> this.matchMetric((Meter.Id)m)));
        config.meterFilter(new MeterFilter(){

            public Meter.Id map(Meter.Id id) {
                return CloudWatchMetricFilter.this.mapMetric(id);
            }
        });
    }

    private boolean matchMetric(Meter.Id metric) {
        return this.matchMetricName(metric.getName());
    }

    private boolean matchMetricName(String metricName) {
        return this.allowedMetrics.stream().anyMatch(metricName::matches);
    }

    private Meter.Id mapMetric(Meter.Id metric) {
        List configuredCloudwatchTags = this.dimensions.entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toList());
        List existingTags = metric.getTags();
        if (Objects.isNull(metric.getBaseUnit()) || !this.isValidUnit(metric.getBaseUnit())) {
            metric = metric.withBaseUnit("None");
        }
        if (Objects.nonNull(existingTags) && !existingTags.isEmpty()) {
            String newName = metric.getName() + "." + String.join((CharSequence)".", existingTags.stream().map(e -> this.toCamelCase(e.getValue(), true)).collect(Collectors.toList()));
            metric = metric.withName(newName);
        }
        return metric.replaceTags(configuredCloudwatchTags);
    }

    private boolean isValidUnit(String baseUnit) {
        return StandardUnit.fromValue((String)baseUnit) != StandardUnit.UNKNOWN_TO_SDK_VERSION;
    }

    private String toCamelCase(String value, boolean startWithLowerCase) {
        CharSequence[] strings;
        if (Objects.nonNull(value) && (strings = StringUtils.split((String)value.toLowerCase(), (String)" ")) != null) {
            int i;
            int n = i = startWithLowerCase ? 1 : 0;
            while (i < strings.length) {
                strings[i] = StringUtils.capitalize((String)strings[i]);
                ++i;
            }
            return String.join((CharSequence)"", strings);
        }
        return value;
    }
}

