/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.metrics.cloudwatch.controller;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="metricvalues")
public class MetricValuesEndpoint {
    private final MeterRegistry registry;

    public MetricValuesEndpoint(MeterRegistry registry) {
        this.registry = registry;
    }

    @ReadOperation
    public List<MetricResponse> metricValues() {
        List meters = this.registry.getMeters();
        if (meters.isEmpty()) {
            return null;
        }
        ArrayList<MetricResponse> result = new ArrayList<MetricResponse>();
        for (Meter meter : meters) {
            Map<Statistic, Double> samples = this.getSamples(Collections.singletonList(meter));
            Map<String, Set<String>> availableTags = this.getAvailableTags(Collections.singletonList(meter));
            Meter.Id meterId = meter.getId();
            result.add(new MetricResponse(meterId.getName(), meterId.getDescription(), meterId.getBaseUnit(), this.asList(samples, Sample::new), this.asList(availableTags, AvailableTag::new)));
        }
        return result;
    }

    private Map<Statistic, Double> getSamples(Collection<Meter> meters) {
        LinkedHashMap<Statistic, Double> samples = new LinkedHashMap<Statistic, Double>();
        meters.forEach(meter -> this.mergeMeasurements((Map<Statistic, Double>)samples, (Meter)meter));
        return samples;
    }

    private void mergeMeasurements(Map<Statistic, Double> samples, Meter meter) {
        meter.measure().forEach(measurement -> samples.merge(measurement.getStatistic(), measurement.getValue(), this.mergeFunction(measurement.getStatistic())));
    }

    private <K, V, T> List<T> asList(Map<K, V> map, BiFunction<K, V, T> mapper) {
        return map.entrySet().stream().map(entry -> mapper.apply(entry.getKey(), entry.getValue())).collect(Collectors.toList());
    }

    private BiFunction<Double, Double, Double> mergeFunction(Statistic statistic) {
        return Statistic.MAX.equals((Object)statistic) ? Double::max : Double::sum;
    }

    private Map<String, Set<String>> getAvailableTags(Collection<Meter> meters) {
        HashMap<String, Set<String>> availableTags = new HashMap<String, Set<String>>();
        meters.forEach(meter -> this.mergeAvailableTags((Map<String, Set<String>>)availableTags, (Meter)meter));
        return availableTags;
    }

    private void mergeAvailableTags(Map<String, Set<String>> availableTags, Meter meter) {
        meter.getId().getTags().forEach(tag -> {
            Set<String> value = Collections.singleton(tag.getValue());
            availableTags.merge(tag.getKey(), value, this::merge);
        });
    }

    private <T> Set<T> merge(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1.size() + set2.size());
        result.addAll(set1);
        result.addAll(set2);
        return result;
    }

    public static final class Sample {
        private final Statistic statistic;
        private final Double value;

        Sample(Statistic statistic, Double value) {
            this.statistic = statistic;
            this.value = value;
        }

        public Statistic getStatistic() {
            return this.statistic;
        }

        public Double getValue() {
            return this.value;
        }

        public String toString() {
            return "MeasurementSample{statistic=" + this.statistic + ", value=" + this.value + '}';
        }
    }

    public static final class AvailableTag {
        private final String tag;
        private final Set<String> values;

        AvailableTag(String tag, Set<String> values) {
            this.tag = tag;
            this.values = values;
        }

        public String getTag() {
            return this.tag;
        }

        public Set<String> getValues() {
            return this.values;
        }
    }

    public static final class MetricResponse {
        private final String name;
        private final String description;
        private final String baseUnit;
        private final List<Sample> measurements;
        private final List<AvailableTag> availableTags;

        MetricResponse(String name, String description, String baseUnit, List<Sample> measurements, List<AvailableTag> availableTags) {
            this.name = name;
            this.description = description;
            this.baseUnit = baseUnit;
            this.measurements = measurements;
            this.availableTags = availableTags;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public List<Sample> getMeasurements() {
            return this.measurements;
        }

        public List<AvailableTag> getAvailableTags() {
            return this.availableTags;
        }
    }
}

