/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.metrics.cloudwatch.configuration;

import de.otto.edison.aws.configuration.AwsProperties;
import de.otto.edison.metrics.cloudwatch.CloudWatchMetricFilter;
import de.otto.edison.metrics.cloudwatch.CloudWatchMetricsProperties;
import de.otto.edison.metrics.cloudwatch.CloudWatchProperties;
import de.otto.edison.metrics.cloudwatch.FilteredCloudWatchMeterRegistry;
import de.otto.edison.metrics.cloudwatch.configuration.CloudWatchPropertiesConfigAdapter;
import io.micrometer.cloudwatch2.CloudWatchConfig;
import io.micrometer.cloudwatch2.CloudWatchMeterRegistry;
import io.micrometer.core.instrument.Clock;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;

@Configuration
@EnableConfigurationProperties(value={CloudWatchProperties.class, CloudWatchMetricsProperties.class})
@ConditionalOnProperty(prefix="management.metrics.export.cloudwatch", name={"namespace"})
@ConditionalOnClass(value={CloudWatchMeterRegistry.class})
public class CloudWatchExportAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"management.metrics.export.cloudwatch.enabled"}, matchIfMissing=true)
    public CloudWatchMeterRegistry cloudWatchMeterRegistry(CloudWatchMetricFilter cloudWatchMetricFilter, CloudWatchConfig cloudWatchConfig, Clock micrometerClock, CloudWatchAsyncClient cloudWatchAsyncClient) {
        return new FilteredCloudWatchMeterRegistry(cloudWatchMetricFilter, cloudWatchConfig, micrometerClock, cloudWatchAsyncClient);
    }

    @Bean
    public CloudWatchMetricFilter cloudWatchMetricFilter(CloudWatchMetricsProperties metricsProperties) {
        CloudWatchMetricFilter cloudWatchMetricFilter = new CloudWatchMetricFilter(metricsProperties);
        return cloudWatchMetricFilter;
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudWatchConfig cloudWatchConfig(CloudWatchProperties cloudWatchProperties) {
        return new CloudWatchPropertiesConfigAdapter(cloudWatchProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudWatchAsyncClient cloudWatchAsyncClient(AwsCredentialsProvider credentialsProvider, AwsProperties awsProperties) {
        return (CloudWatchAsyncClient)((CloudWatchAsyncClientBuilder)((CloudWatchAsyncClientBuilder)CloudWatchAsyncClient.builder().credentialsProvider(credentialsProvider)).region(Region.of((String)awsProperties.getRegion()))).build();
    }
}

