/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.metrics.cloudwatch;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MemoryUsageMetric {
    private final MemoryMXBean mxBean;
    private final List<MemoryPoolMXBean> memoryPools;
    private final MeterRegistry meterRegistry;

    public MemoryUsageMetric(MeterRegistry meterRegistry) {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans(), meterRegistry);
    }

    public MemoryUsageMetric(MemoryMXBean mxBean, Collection<MemoryPoolMXBean> memoryPools, MeterRegistry meterRegistry) {
        this.mxBean = mxBean;
        this.memoryPools = new ArrayList<MemoryPoolMXBean>(memoryPools);
        this.meterRegistry = meterRegistry;
        this.registerMetrics(meterRegistry);
    }

    private void registerMetrics(MeterRegistry meterRegistry) {
        Gauge.builder((String)"memory.heap.usage", (Object)this, MemoryUsageMetric::getHeapUsage).baseUnit("None").register(meterRegistry);
        Gauge.builder((String)"memory.heap.used", (Object)this, MemoryUsageMetric::getHeapUsed).baseUnit("bytes").register(meterRegistry);
        Gauge.builder((String)"memory.heap.max", (Object)this, MemoryUsageMetric::getHeapMax).baseUnit("bytes").register(meterRegistry);
    }

    double getHeapUsage() {
        MemoryUsage usage = this.mxBean.getHeapMemoryUsage();
        return usage.getUsed() / usage.getMax();
    }

    double getHeapUsed() {
        return this.mxBean.getHeapMemoryUsage().getUsed();
    }

    double getHeapMax() {
        return this.mxBean.getHeapMemoryUsage().getMax();
    }
}

