/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.metrics.cloudwatch;

import com.codahale.metrics.MetricRegistry;
import de.otto.edison.aws.configuration.AwsProperties;
import de.otto.edison.metrics.cloudwatch.CloudWatchMetricsProperties;
import de.otto.edison.metrics.cloudwatch.CloudWatchMetricsReporter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.core.auth.AwsCredentialsProvider;
import software.amazon.awssdk.core.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClientBuilder;

@Configuration
@EnableConfigurationProperties(value={AwsProperties.class, CloudWatchMetricsProperties.class})
@ConditionalOnProperty(name={"edison.aws.metrics.cloudWatch.enabled"}, havingValue="true")
public class CloudWatchMetricsReporterConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchMetricsReporterConfiguration.class);

    @Bean
    public CloudWatchMetricsReporter cloudWatchReporter(MetricRegistry metricRegistry, CloudWatchAsyncClient cloudWatchAsync, CloudWatchMetricsProperties metricsProperties) {
        CloudWatchMetricsReporter reporter = new CloudWatchMetricsReporter(metricRegistry, metricsProperties.getAllowedMetrics(), metricsProperties.getNamespace(), cloudWatchAsync);
        reporter.start(1L, TimeUnit.MINUTES);
        LOG.info("started cloudWatch metrics reporter");
        return reporter;
    }

    @Bean
    public CloudWatchAsyncClient cloudWatchAsync(AwsCredentialsProvider awsCredentialsProvider, AwsProperties awsProperties) {
        return (CloudWatchAsyncClient)((CloudWatchAsyncClientBuilder)((CloudWatchAsyncClientBuilder)CloudWatchAsyncClient.builder().region(Region.of((String)awsProperties.getRegion()))).credentialsProvider(awsCredentialsProvider)).build();
    }
}

