/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.metrics.cloudwatch;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;

public class CloudWatchMetricsReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchMetricsReporter.class);
    private final CloudWatchAsyncClient cloudWatchClient;
    private final String namespace;
    private Clock clock;

    public CloudWatchMetricsReporter(MetricRegistry registry, List<String> allowedMetrics, String namespace, CloudWatchAsyncClient cloudWatchClient) {
        super(registry, "cloudWatch-reporter", (name, metric) -> CloudWatchMetricsReporter.shouldReportToCloudWatch(name, allowedMetrics), TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        this.cloudWatchClient = cloudWatchClient;
        this.namespace = namespace;
    }

    protected static boolean shouldReportToCloudWatch(String name, List<String> allowedMetrics) {
        return allowedMetrics.stream().anyMatch(e -> name.matches((String)e));
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        gauges.forEach(this::reportGauge);
        counters.forEach(this::reportCounter);
        histograms.forEach(this::reportCounter);
        meters.forEach(this::reportCounter);
        timers.forEach(this::reportCounter);
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    private void reportGauge(String name, Gauge<Number> gauge) {
        this.reportToCloudWatch(name, ((Number)gauge.getValue()).doubleValue());
    }

    private void reportCounter(String name, Counting counter) {
        this.reportToCloudWatch(name, counter.getCount());
    }

    private void reportToCloudWatch(String name, double value) {
        this.cloudWatchClient.putMetricData((PutMetricDataRequest)PutMetricDataRequest.builder().namespace(this.namespace).metricData(new MetricDatum[]{(MetricDatum)MetricDatum.builder().metricName(name).value(Double.valueOf(value)).timestamp(this.clock != null ? this.clock.instant() : Instant.now()).build()}).build());
        LOG.debug("sending metric to cloudWatch: " + name + " : " + value);
    }
}

