/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.aws.dynamodb.jobs;

import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.domain.JobMessage;
import de.otto.edison.jobs.domain.Level;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class JobInfoConverter {
    public static final String ID = "id";
    public static final String HOSTNAME = "hostname";
    public static final String JOB_TYPE = "jobType";
    public static final String JOB_STATUS = "jobStatus";
    public static final String STARTED = "started";
    public static final String STOPPED = "stopped";
    public static final String LAST_UPDATED = "lastUpdated";
    public static final String MESSAGES = "messages";
    public static final String MSG_LEVEL = "level";
    public static final String MSG = "message";
    public static final String MSG_TIMESTAMP = "timestamp";

    public static Map<String, AttributeValue> convertJobInfo(JobInfo jobInfo) {
        HashMap<String, AttributeValue> itemsMap = new HashMap<String, AttributeValue>();
        itemsMap.put(ID, JobInfoConverter.createStringAttributeValue(jobInfo.getJobId()));
        itemsMap.put(HOSTNAME, JobInfoConverter.createStringAttributeValue(jobInfo.getHostname()));
        itemsMap.put(JOB_TYPE, JobInfoConverter.createStringAttributeValue(jobInfo.getJobType()));
        itemsMap.put(JOB_STATUS, JobInfoConverter.createStringAttributeValue(jobInfo.getStatus().name()));
        itemsMap.put(STARTED, JobInfoConverter.createDateAttributeValue(jobInfo.getStarted()));
        itemsMap.put(LAST_UPDATED, JobInfoConverter.createDateAttributeValue(jobInfo.getLastUpdated()));
        if (jobInfo.getStopped().isPresent()) {
            itemsMap.put(STOPPED, JobInfoConverter.createDateAttributeValue((OffsetDateTime)jobInfo.getStopped().get()));
        }
        List attributeValues = jobInfo.getMessages().stream().map(JobInfoConverter::mapJobMessage).collect(Collectors.toList());
        itemsMap.put(MESSAGES, (AttributeValue)AttributeValue.builder().l(attributeValues).build());
        return itemsMap;
    }

    private static AttributeValue mapJobMessage(JobMessage msg) {
        HashMap<String, AttributeValue> msgMap = new HashMap<String, AttributeValue>();
        msgMap.put(MSG, JobInfoConverter.createStringAttributeValue(msg.getMessage()));
        msgMap.put(MSG_LEVEL, JobInfoConverter.createStringAttributeValue(msg.getLevel().getKey()));
        msgMap.put(MSG_TIMESTAMP, JobInfoConverter.createDateAttributeValue(msg.getTimestamp()));
        return (AttributeValue)AttributeValue.builder().m(msgMap).build();
    }

    public static Map<String, AttributeValue> createJobIdMap(String jobId) {
        HashMap<String, AttributeValue> idMap = new HashMap<String, AttributeValue>();
        idMap.put(ID, JobInfoConverter.createStringAttributeValue(jobId));
        return idMap;
    }

    public static JobInfo convert(Map<String, AttributeValue> attributeValueMap) {
        JobInfo.Builder builder = JobInfo.builder();
        JobInfoConverter.stringValueFromAttribute(attributeValueMap, ID).ifPresent(arg_0 -> ((JobInfo.Builder)builder).setJobId(arg_0));
        JobInfoConverter.stringValueFromAttribute(attributeValueMap, HOSTNAME).ifPresent(arg_0 -> ((JobInfo.Builder)builder).setHostname(arg_0));
        JobInfoConverter.stringValueFromAttribute(attributeValueMap, JOB_TYPE).ifPresent(arg_0 -> ((JobInfo.Builder)builder).setJobType(arg_0));
        JobInfoConverter.stringValueFromAttribute(attributeValueMap, JOB_STATUS).ifPresent(s -> builder.setStatus(JobInfo.JobStatus.valueOf((String)s)));
        JobInfoConverter.dateValueFromAttribute(attributeValueMap, STARTED).ifPresent(arg_0 -> ((JobInfo.Builder)builder).setStarted(arg_0));
        JobInfoConverter.dateValueFromAttribute(attributeValueMap, STOPPED).ifPresent(arg_0 -> ((JobInfo.Builder)builder).setStopped(arg_0));
        JobInfoConverter.dateValueFromAttribute(attributeValueMap, LAST_UPDATED).ifPresent(arg_0 -> ((JobInfo.Builder)builder).setLastUpdated(arg_0));
        List messages = attributeValueMap.get(MESSAGES).l();
        List jobMessages = messages.stream().map(JobInfoConverter::mapAttributeValueToJobMessage).collect(Collectors.toList());
        builder.setMessages(jobMessages);
        return builder.build();
    }

    private static JobMessage mapAttributeValueToJobMessage(AttributeValue attr) {
        Map valueMap = attr.m();
        String level = JobInfoConverter.stringValueFromAttribute(valueMap, MSG_LEVEL).orElse(Level.INFO.getKey());
        String msg = JobInfoConverter.stringValueFromAttribute(valueMap, MSG).orElse("");
        OffsetDateTime dateTime = JobInfoConverter.dateValueFromAttribute(valueMap, MSG_TIMESTAMP).orElse(null);
        return JobMessage.jobMessage((Level)Level.ofKey((String)level), (String)msg, (OffsetDateTime)dateTime);
    }

    private static AttributeValue createStringAttributeValue(String value) {
        return (AttributeValue)AttributeValue.builder().s(value).build();
    }

    private static AttributeValue createDateAttributeValue(OffsetDateTime dateTime) {
        String formattedDateTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTime);
        return (AttributeValue)AttributeValue.builder().s(formattedDateTime).build();
    }

    private static final Optional<String> stringValueFromAttribute(Map<String, AttributeValue> attributeValueMap, String key) {
        if (attributeValueMap.containsKey(key)) {
            return Optional.of(attributeValueMap.get(key).s());
        }
        return Optional.empty();
    }

    private static final Optional<OffsetDateTime> dateValueFromAttribute(Map<String, AttributeValue> attributeValueMap, String key) {
        if (attributeValueMap.containsKey(key)) {
            String formattedDateTime = attributeValueMap.get(key).s();
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(formattedDateTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return Optional.of(offsetDateTime);
        }
        return Optional.empty();
    }
}

