/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.aws.dynamodb.jobs;

import de.otto.edison.aws.dynamodb.jobs.DynamoDbJobRepoProperties;
import de.otto.edison.jobs.domain.JobMeta;
import de.otto.edison.jobs.repository.JobMetaRepository;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.util.ImmutableMapParameter;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;

public class DynamoDbJobMetaRepository
implements JobMetaRepository {
    static final String JOB_TYPE = "JOB_TYPE";
    static final String KEY_RUNNING = "running";
    static final String KEY_DISABLED = "disabled";
    private final DynamoDBClient dynamoDBClient;
    private final String jobMetaTableName;

    public DynamoDbJobMetaRepository(DynamoDBClient dynamoDBClient, DynamoDbJobRepoProperties properties) {
        this.dynamoDBClient = dynamoDBClient;
        this.jobMetaTableName = properties.getJobMetaTableName();
    }

    public JobMeta getJobMeta(String jobType) {
        GetItemResponse response = this.getItem(jobType);
        Map item = response.item();
        if (item != null) {
            Map<String, String> meta = item.keySet().stream().filter(key -> !key.startsWith(KEY_RUNNING) && !key.startsWith(KEY_DISABLED) && !key.startsWith(JOB_TYPE)).collect(Collectors.toMap(key -> key, key -> ((AttributeValue)item.get(key)).s()));
            boolean isRunning = item.containsKey(KEY_RUNNING);
            boolean isDisabled = item.containsKey(KEY_DISABLED);
            String comment = ((AttributeValue)item.get(KEY_DISABLED)).s();
            return new JobMeta(jobType, isRunning, isDisabled, comment, meta);
        }
        return new JobMeta(jobType, false, false, "", Collections.emptyMap());
    }

    public boolean createValue(String jobType, String key, String value) {
        UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.jobMetaTableName).key((Map)ImmutableMapParameter.of((Object)JOB_TYPE, (Object)AttributeValue.builder().s(jobType).build())).updateExpression("SET " + key + " = :value").conditionExpression("attribute_not_exists(" + key + ")").expressionAttributeValues((Map)ImmutableMapParameter.of((Object)":value", (Object)AttributeValue.builder().s(value).build())).returnValues(ReturnValue.ALL_NEW).build();
        try {
            this.dynamoDBClient.updateItem(request);
            return true;
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
    }

    public boolean setRunningJob(String jobType, String jobId) {
        return this.createValue(jobType, KEY_RUNNING, jobId);
    }

    public String getRunningJob(String jobType) {
        return this.getValue(jobType, KEY_RUNNING);
    }

    public void clearRunningJob(String jobType) {
        this.setValue(jobType, KEY_RUNNING, null);
    }

    public void disable(String jobType, String comment) {
        this.setValue(jobType, KEY_DISABLED, comment != null ? comment : "");
    }

    public void enable(String jobType) {
        this.setValue(jobType, KEY_DISABLED, null);
    }

    public String setValue(String jobType, String key, String value) {
        UpdateItemRequest request = value == null ? this.removeKeyRequest(jobType, key) : this.updateKeyRequest(jobType, key, value);
        UpdateItemResponse updateItemResponse = this.dynamoDBClient.updateItem(request);
        if (updateItemResponse.attributes() != null) {
            return ((AttributeValue)updateItemResponse.attributes().getOrDefault(key, AttributeValue.builder().build())).s();
        }
        return null;
    }

    private UpdateItemRequest updateKeyRequest(String jobType, String key, String value) {
        AttributeValue attributeValue = value.isEmpty() ? (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build() : (AttributeValue)AttributeValue.builder().s(value).build();
        return (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.jobMetaTableName).key((Map)ImmutableMapParameter.of((Object)JOB_TYPE, (Object)AttributeValue.builder().s(jobType).build())).returnValues(ReturnValue.UPDATED_OLD).updateExpression("SET " + key + " = :value").expressionAttributeValues((Map)ImmutableMapParameter.of((Object)":value", (Object)attributeValue)).build();
    }

    private UpdateItemRequest removeKeyRequest(String jobType, String key) {
        return (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.jobMetaTableName).key((Map)ImmutableMapParameter.of((Object)JOB_TYPE, (Object)AttributeValue.builder().s(jobType).build())).returnValues(ReturnValue.UPDATED_OLD).updateExpression("REMOVE " + key).build();
    }

    public String getValue(String jobType, String key) {
        GetItemResponse response = this.getItem(jobType);
        return ((AttributeValue)response.item().getOrDefault(key, AttributeValue.builder().build())).s();
    }

    private GetItemResponse getItem(String jobType) {
        GetItemRequest request = (GetItemRequest)GetItemRequest.builder().tableName(this.jobMetaTableName).key((Map)ImmutableMapParameter.of((Object)JOB_TYPE, (Object)AttributeValue.builder().s(jobType).build())).consistentRead(Boolean.valueOf(true)).build();
        return this.dynamoDBClient.getItem(request);
    }

    public Set<String> findAllJobTypes() {
        ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.jobMetaTableName).build();
        ScanResponse response = this.dynamoDBClient.scan(scanRequest);
        return response.items().stream().map(item -> ((AttributeValue)item.get(JOB_TYPE)).s()).collect(Collectors.toSet());
    }

    public void deleteAll() {
        throw new UnsupportedOperationException();
    }
}

