/*
 * Decompiled with CFR 0.152.
 */
package de.otto.edison.aws.dynamo.jobs;

import com.amazonaws.util.ImmutableMapParameter;
import com.google.common.collect.Lists;
import de.otto.edison.aws.dynamo.jobs.DynamoDbJobRepoProperties;
import de.otto.edison.aws.dynamo.jobs.JobInfoConverter;
import de.otto.edison.jobs.domain.JobInfo;
import de.otto.edison.jobs.domain.JobMessage;
import de.otto.edison.jobs.repository.JobRepository;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public class DynamoDbJobRepository
implements JobRepository {
    private static final Comparator<JobInfo> STARTED_TIME_DESC_COMPARATOR = Comparator.comparing(JobInfo::getStarted, OffsetDateTime::compareTo).reversed();
    private DynamoDBClient dynamoDBClient;
    private DynamoDbJobRepoProperties dynamoJobRepoProperties;

    public DynamoDbJobRepository(DynamoDBClient dynamoDBClient, DynamoDbJobRepoProperties dynamoJobRepoProperties) {
        this.dynamoDBClient = dynamoDBClient;
        this.dynamoJobRepoProperties = dynamoJobRepoProperties;
    }

    public Optional<JobInfo> findOne(String jobId) {
        Map<String, AttributeValue> jobIdMap = JobInfoConverter.createJobIdMap(jobId);
        GetItemRequest itemRequest = (GetItemRequest)GetItemRequest.builder().tableName(this.dynamoJobRepoProperties.getJobInfoTableName()).key(jobIdMap).build();
        GetItemResponse itemResponse = this.dynamoDBClient.getItem(itemRequest);
        if (itemResponse == null || itemResponse.item() == null || itemResponse.item().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(JobInfoConverter.convert(itemResponse.item()));
    }

    public List<JobInfo> findLatest(int maxCount) {
        return this.findAll().stream().sorted(STARTED_TIME_DESC_COMPARATOR).limit(maxCount).collect(Collectors.toList());
    }

    public List<JobInfo> findLatestJobsDistinct() {
        HashSet typeSet = new HashSet();
        return this.findAll().stream().sorted(STARTED_TIME_DESC_COMPARATOR).filter(j -> Objects.nonNull(j.getJobType())).filter(j -> typeSet.add(j.getJobType())).collect(Collectors.toList());
    }

    public List<JobInfo> findLatestBy(String type, int maxCount) {
        return this.findAll().stream().sorted(STARTED_TIME_DESC_COMPARATOR).filter(jobInfo -> jobInfo.getJobType().equalsIgnoreCase(type)).limit(maxCount).collect(Collectors.toList());
    }

    public List<JobInfo> findRunningWithoutUpdateSince(OffsetDateTime timeOffset) {
        return this.findAll().stream().filter(jobInfo -> !jobInfo.isStopped() && jobInfo.getLastUpdated().isBefore(timeOffset)).sorted(STARTED_TIME_DESC_COMPARATOR).collect(Collectors.toList());
    }

    public List<JobInfo> findAll() {
        ScanResponse scanResponse = this.dynamoDBClient.scan((ScanRequest)ScanRequest.builder().tableName(this.dynamoJobRepoProperties.getJobInfoTableName()).build());
        return this.toJobInfoList(scanResponse);
    }

    public List<JobInfo> findAllJobInfoWithoutMessages() {
        return this.findAll().stream().sorted(STARTED_TIME_DESC_COMPARATOR).map(job -> job.copy().setMessages(Collections.emptyList()).build()).collect(Collectors.toList());
    }

    public List<JobInfo> findByType(String jobType) {
        ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.dynamoJobRepoProperties.getJobInfoTableName()).filterExpression("jobType= :jobType").expressionAttributeValues((Map)ImmutableMapParameter.of((Object)":jobType", (Object)AttributeValue.builder().s(jobType).build())).build();
        ScanResponse scanResponse = this.dynamoDBClient.scan(scanRequest);
        return this.toJobInfoList(scanResponse);
    }

    private List<JobInfo> toJobInfoList(ScanResponse scanResponse) {
        return scanResponse.items().stream().map(JobInfoConverter::convert).collect(Collectors.toList());
    }

    public JobInfo createOrUpdate(JobInfo job) {
        Map<String, AttributeValue> item = JobInfoConverter.convertJobInfo(job);
        PutItemRequest putItemRequest = (PutItemRequest)PutItemRequest.builder().tableName(this.dynamoJobRepoProperties.getJobInfoTableName()).item(item).build();
        this.dynamoDBClient.putItem(putItemRequest);
        return job;
    }

    public void removeIfStopped(String jobId) {
        Optional<JobInfo> jobInfo = this.findOne(jobId);
        jobInfo.ifPresent(job -> {
            if (job.isStopped()) {
                this.remove(jobId);
            }
        });
    }

    private void remove(String jobId) {
        DeleteItemRequest deleteItemRequest = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.dynamoJobRepoProperties.getJobInfoTableName()).key((Map)ImmutableMapParameter.of((Object)"id", (Object)AttributeValue.builder().s(jobId).build())).build();
        this.dynamoDBClient.deleteItem(deleteItemRequest);
    }

    public JobInfo.JobStatus findStatus(String jobId) {
        Optional<JobInfo> jobInfo = this.findOne(jobId);
        if (jobInfo.isPresent()) {
            return jobInfo.get().getStatus();
        }
        return null;
    }

    public void appendMessage(String jobId, JobMessage jobMessage) {
        Optional<JobInfo> jobInfo = this.findOne(jobId);
        jobInfo.ifPresent(jobInfo1 -> {
            JobInfo modifiedJobInfo = jobInfo1.copy().addMessage(jobMessage).build();
            this.createOrUpdate(modifiedJobInfo);
        });
    }

    public void setJobStatus(String jobId, JobInfo.JobStatus jobStatus) {
        Optional<JobInfo> jobInfo = this.findOne(jobId);
        jobInfo.ifPresent(jobInfo1 -> {
            JobInfo modifiedJobInfo = jobInfo1.copy().setStatus(jobStatus).build();
            this.createOrUpdate(modifiedJobInfo);
        });
    }

    public void setLastUpdate(String jobId, OffsetDateTime lastUpdate) {
        Optional<JobInfo> jobInfo = this.findOne(jobId);
        jobInfo.ifPresent(jobInfo1 -> {
            JobInfo modifiedJobInfo = jobInfo1.copy().setLastUpdated(lastUpdate).build();
            this.createOrUpdate(modifiedJobInfo);
        });
    }

    public long size() {
        return this.findAll().size();
    }

    public void deleteAll() {
        List deleteRequests = this.findAll().stream().map(jobInfo -> (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key((Map)ImmutableMapParameter.of((Object)"id", (Object)AttributeValue.builder().s(jobInfo.getJobId()).build())).build()).build()).collect(Collectors.toList());
        Lists.partition(deleteRequests, (int)25).forEach(this::deleteParts);
    }

    private void deleteParts(List<WriteRequest> part) {
        BatchWriteItemResponse batchWriteItemResponse = this.batchDeleteItems((Map<String, List<WriteRequest>>)ImmutableMapParameter.of((Object)this.dynamoJobRepoProperties.getJobInfoTableName(), part));
        while (!batchWriteItemResponse.unprocessedItems().isEmpty()) {
            this.batchDeleteItems(batchWriteItemResponse.unprocessedItems());
        }
    }

    private BatchWriteItemResponse batchDeleteItems(Map<String, List<WriteRequest>> requestItems) {
        BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(requestItems).build();
        return this.dynamoDBClient.batchWriteItem(batchWriteItemRequest);
    }
}

