/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.marvin.progresstracker.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class Progress {
    private final BigInteger stepsDone;
    private final BigInteger stepsTotal;
    private final double progress;

    public Progress() {
        this.stepsDone = null;
        this.stepsTotal = null;
        this.progress = 0.0;
    }

    public Progress(BigInteger stepsDone, BigInteger stepsTotal) {
        if (stepsDone == null) {
            throw new RuntimeException("Parameter  'stepsDone' must not be null");
        }
        if (stepsTotal == null) {
            throw new RuntimeException("Parameter 'stepsTotal' must not be null");
        }
        if (stepsDone.compareTo(stepsTotal) > 0) {
            throw new RuntimeException("Parameter 'stepsDone' must not be greater than 'stepsTotal'");
        }
        this.stepsDone = stepsDone;
        this.stepsTotal = stepsTotal;
        this.progress = new BigDecimal(stepsDone).divide(new BigDecimal(stepsTotal), 15, RoundingMode.HALF_UP).doubleValue() * 100.0;
        assert (this.progress >= 0.0);
    }

    public BigInteger getStepsDone() {
        return this.stepsDone;
    }

    public BigInteger getStepsTotal() {
        return this.stepsTotal;
    }

    public double getProgress() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Progress progress1 = (Progress)o;
        if (Double.compare(progress1.progress, this.progress) != 0) {
            return false;
        }
        if (this.stepsDone != null ? !this.stepsDone.equals(progress1.stepsDone) : progress1.stepsDone != null) {
            return false;
        }
        return this.stepsTotal != null ? this.stepsTotal.equals(progress1.stepsTotal) : progress1.stepsTotal == null;
    }

    public int hashCode() {
        int result = this.stepsDone != null ? this.stepsDone.hashCode() : 0;
        result = 31 * result + (this.stepsTotal != null ? this.stepsTotal.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.progress);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return String.format("Progress: %s of %s (%s%%)", this.stepsDone, this.stepsTotal, this.progress);
    }
}

