/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.marvin.progresstracker.impl;

import com.gitlab.marvin.progresstracker.api.BackgroundProgressCollector;
import com.gitlab.marvin.progresstracker.api.ProgressReceiver;
import com.gitlab.marvin.progresstracker.api.ProgressSender;
import com.gitlab.marvin.progresstracker.utils.Progress;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class AbstractBackgroundProgressCollector
implements BackgroundProgressCollector {
    private final ConcurrentMap<ProgressSender, Progress> senderProgress;
    private final Set<ProgressReceiver> progressReceivers;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicReference<Long> updateIntervalMillis = new AtomicReference<Long>(40L);
    private final AtomicBoolean changed = new AtomicBoolean(true);

    public AbstractBackgroundProgressCollector() {
        this.senderProgress = new ConcurrentHashMap<ProgressSender, Progress>();
        this.progressReceivers = new HashSet<ProgressReceiver>();
    }

    @Override
    public void reportProgress(ProgressSender sender, Progress progress) {
        if (sender == null) {
            throw new RuntimeException("Parameter 'sender' must not be null");
        }
        if (progress == null) {
            throw new RuntimeException("Parameter 'progress' must not be null");
        }
        Progress oldValue = this.senderProgress.put(sender, progress);
        if (oldValue == null || !oldValue.equals(progress)) {
            this.changed.compareAndSet(false, true);
        }
    }

    @Override
    public void registerProgressReceiver(ProgressReceiver receiver) {
        if (receiver == null) {
            throw new RuntimeException("Parameter 'receiver' must not be null");
        }
        this.progressReceivers.add(receiver);
    }

    @Override
    public void unregisterProgressReceiver(ProgressReceiver receiver) {
        if (receiver == null) {
            throw new RuntimeException("Parameter 'receiver' must not be null");
        }
        this.progressReceivers.remove(receiver);
    }

    @Override
    public void sendProgress() {
        Progress progress = this.calculateProgress();
        for (ProgressReceiver receiver : this.progressReceivers) {
            receiver.notifiy(progress);
        }
        if (progress.getStepsDone() != null && progress.getStepsTotal() != null && progress.getStepsDone().compareTo(progress.getStepsTotal()) >= 0 && progress.getStepsTotal().compareTo(BigInteger.ZERO) > 0) {
            this.finished.set(true);
        }
    }

    private Progress calculateProgress() {
        BigInteger stepsTotal = BigInteger.ZERO;
        BigInteger stepsDone = BigInteger.ZERO;
        LinkedList values = new LinkedList(this.senderProgress.values());
        for (Progress progress : values) {
            stepsTotal = stepsTotal.add(progress.getStepsTotal());
            stepsDone = stepsDone.add(progress.getStepsDone());
        }
        if (stepsTotal.compareTo(BigInteger.ZERO) <= 0) {
            return new Progress();
        }
        return new Progress(stepsDone, stepsTotal);
    }

    @Override
    public void run() {
        this.finished.set(false);
        this.running.set(true);
        this.changed.set(true);
        while (!this.finished.get()) {
            if (this.changed.compareAndSet(true, false)) {
                this.sendProgress();
            }
            try {
                Thread.sleep(this.updateIntervalMillis.get());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.sendProgress();
        this.running.set(false);
    }

    @Override
    public long getUpdateIntervalMillis() {
        return this.updateIntervalMillis.get();
    }

    @Override
    public void setUpdateIntervalMillis(long updateIntervalMillis) {
        this.updateIntervalMillis.set(updateIntervalMillis);
    }
}

