/*
 * Decompiled with CFR 0.152.
 */
package de.osshangar.compiler;

import de.osshangar.compiler.CompilerException;
import de.osshangar.compiler.CompilerFileManager;
import de.osshangar.compiler.JavaByteObject;
import de.osshangar.compiler.JavaStringObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class Compiler {
    public static byte[] compile(String className, String sourceCode) throws CompilerException {
        List<String> options;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaByteObject javaByteObject = new JavaByteObject(className);
        CompilerFileManager compilerFileManager = new CompilerFileManager(compiler.getStandardFileManager(diagnostics, null, null), javaByteObject);
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, compilerFileManager, diagnostics, options = Collections.emptyList(), null, () -> {
            JavaStringObject javaFileObject = new JavaStringObject(className, sourceCode);
            return Collections.singletonList(javaFileObject).iterator();
        });
        boolean compilationSuccessful = compilationTask.call();
        if (!compilationSuccessful) {
            String message = diagnostics.getDiagnostics().stream().map(Object::toString).collect(Collectors.joining());
            throw new CompilerException(String.format("Failed to compile class '%s':\n%s", className, message));
        }
        return javaByteObject.getBytes();
    }
}

