/*
 * Decompiled with CFR 0.152.
 */
package de.osshangar.plugin.classloader;

import java.util.Map;
import lombok.NonNull;

public class PluginClassLoader
extends ClassLoader {
    private final Map<String, byte[]> byteCodes;

    public PluginClassLoader(@NonNull Map<String, byte[]> classesFiles) {
        super(PluginClassLoader.class.getClassLoader());
        if (classesFiles == null) {
            throw new NullPointerException("classesFiles is marked non-null but is null");
        }
        this.byteCodes = classesFiles;
    }

    @Override
    public Class<?> findClass(@NonNull String fullQualifiedClassName) throws ClassNotFoundException {
        if (fullQualifiedClassName == null) {
            throw new NullPointerException("fullQualifiedClassName is marked non-null but is null");
        }
        if (!this.byteCodes.containsKey(fullQualifiedClassName)) {
            throw new ClassNotFoundException(String.format("Did not find class '%s'", fullQualifiedClassName));
        }
        return this.defineClass(fullQualifiedClassName, this.byteCodes.get(fullQualifiedClassName), 0, this.byteCodes.get(fullQualifiedClassName).length);
    }

    @Override
    public Class<?> loadClass(@NonNull String fullQualifiedClassName) throws ClassNotFoundException {
        if (fullQualifiedClassName == null) {
            throw new NullPointerException("fullQualifiedClassName is marked non-null but is null");
        }
        if (this.byteCodes.containsKey(fullQualifiedClassName)) {
            return this.findClass(fullQualifiedClassName);
        }
        ClassLoader defaultLoader = Thread.currentThread().getContextClassLoader();
        return defaultLoader.loadClass(fullQualifiedClassName);
    }

    public Map<String, byte[]> getByteCodes() {
        return this.byteCodes;
    }
}

