/*
 * Decompiled with CFR 0.152.
 */
package de.oscillation.kismet.connector;

import de.benediktmeurer.eui4j.EUI48;
import de.oscillation.kismet.connector.KismetActivationSpec;
import de.oscillation.kismet.connector.KismetMeasuredValue;
import de.oscillation.kismet.connector.KismetMessage;
import de.oscillation.kismet.connector.KismetMessageService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;

public class KismetServerConnection
implements Work {
    private final KismetActivationSpec activationSpec;
    private final MessageEndpointFactory endpointFactory;
    private final Logger logger = Logger.getLogger(KismetServerConnection.class.getName());
    private final Socket socket;

    public KismetServerConnection(KismetActivationSpec activationSpec, MessageEndpointFactory endpointFactory) throws UnknownHostException, IOException {
        if (endpointFactory == null) {
            throw new NullPointerException("endpointFactory must not be null");
        }
        this.activationSpec = activationSpec;
        this.endpointFactory = endpointFactory;
        this.socket = new Socket(activationSpec.getServerName(), (int)activationSpec.getPortNumber());
        this.logger.info("Successfully established new kismet server connection to " + activationSpec.getServerName() + " on port " + activationSpec.getPortNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            OutputStreamWriter out = new OutputStreamWriter(this.socket.getOutputStream());
            this.logger.info("Enabling CLISRC and SOURCE protocols for kismet server connection");
            out.write("!1 ENABLE CLISRC *\n");
            out.write("!2 ENABLE SOURCE *\n");
            out.flush();
            HashMap<UUID, String> droneNames = new HashMap<UUID, String>();
            LinkedList<KismetMeasuredValue> measuredValues = new LinkedList<KismetMeasuredValue>();
            while (true) {
                StringTokenizer tokenizer;
                String header;
                if ("*CLISRC:".equals(header = (tokenizer = new StringTokenizer(in.readLine(), " ")).nextToken())) {
                    tokenizer.nextToken();
                    EUI48 deviceId = EUI48.fromString((String)tokenizer.nextToken());
                    UUID droneId = UUID.fromString(tokenizer.nextToken());
                    long timestamp = Long.parseLong(tokenizer.nextToken());
                    tokenizer.nextToken();
                    int signalStrength = Integer.parseInt(tokenizer.nextToken());
                    measuredValues.add(new KismetMeasuredValue(deviceId, droneId, signalStrength, timestamp));
                    continue;
                }
                if ("*SOURCE:".equals(header)) {
                    String interf = tokenizer.nextToken();
                    String type = tokenizer.nextToken();
                    if (!"drone".equals(interf) || !"drone".equals(type)) continue;
                    String name = tokenizer.nextToken();
                    tokenizer.nextToken();
                    UUID id = UUID.fromString(tokenizer.nextToken());
                    droneNames.put(id, name);
                    continue;
                }
                if (!"*TIME:".equals(header)) continue;
                long timestamp = Long.parseLong(tokenizer.nextToken());
                try {
                    MessageEndpoint messageEndpoint = this.endpointFactory.createEndpoint(null);
                    messageEndpoint.beforeDelivery(KismetMessageService.class.getDeclaredMethod("onMessage", KismetMessage.class));
                    try {
                        KismetMessage message = new KismetMessage(new HashMap(droneNames), measuredValues, timestamp);
                        ((KismetMessageService)messageEndpoint).onMessage(message);
                        measuredValues = new LinkedList();
                    }
                    finally {
                        messageEndpoint.afterDelivery();
                        messageEndpoint.release();
                    }
                }
                catch (Exception exn) {
                    this.logger.log(Level.WARNING, "Failed to pass kismet message to endpoint", exn);
                }
            }
        }
        catch (Exception exn) {
            this.logger.log(Level.SEVERE, "Error in kismet server connection, terminating connection", exn);
            return;
        }
    }

    public void release() {
        try {
            this.socket.close();
        }
        catch (IOException exn) {
            this.logger.log(Level.WARNING, "Failed to close kismet server connection", exn);
        }
    }

    public KismetActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public MessageEndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }
}

