/*
 * Decompiled with CFR 0.152.
 */
package de.oscillation.kismet.connector;

import de.oscillation.kismet.connector.KismetActivationSpec;
import de.oscillation.kismet.connector.KismetServerConnection;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

@Connector(description={"Kismet Resource Adapter"}, eisType="Kismet", vendorName="os-cillation GmbH", version="1.0")
public class KismetResourceAdapter
implements ResourceAdapter,
Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedList<KismetServerConnection> connections = new LinkedList();
    private Logger logger = Logger.getLogger(KismetResourceAdapter.class.getName());
    private WorkManager workManager;

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.logger.info("Starting kismet resource adapter");
        this.workManager = bootstrapContext.getWorkManager();
    }

    public void stop() {
        this.logger.info("Stopping kismet resource adapter");
        this.workManager = null;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec as) throws ResourceException {
        this.logger.info("Activating message endpoint with factory " + endpointFactory + " and activation spec " + as);
        if (as instanceof KismetActivationSpec) {
            KismetActivationSpec activationSpec = (KismetActivationSpec)as;
            activationSpec.validate();
            try {
                KismetServerConnection connection = new KismetServerConnection(activationSpec, endpointFactory);
                this.workManager.scheduleWork((Work)connection);
                this.connections.add(connection);
            }
            catch (Throwable cause) {
                throw new ResourceException("Failed to establish new connection to kismet server at " + activationSpec.getServerName() + " on port " + activationSpec.getPortNumber(), cause);
            }
        } else {
            throw new ResourceException("Expected " + KismetActivationSpec.class.getName() + ", but got " + as.getClass().getName());
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec as) {
        this.logger.info("Deactivating message endpoint with factory " + endpointFactory + " and activation spec " + as);
        Iterator it = this.connections.iterator();
        while (it.hasNext()) {
            KismetServerConnection connection = (KismetServerConnection)it.next();
            if (!connection.getActivationSpec().equals(as) || !connection.getEndpointFactory().equals(endpointFactory)) continue;
            connection.release();
            it.remove();
            return;
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return null;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 11 + (this.workManager == null ? 0 : this.workManager.hashCode());
        hash = hash * 23 + this.connections.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KismetResourceAdapter) {
            KismetResourceAdapter ra = (KismetResourceAdapter)o;
            if ((this.workManager == null ? ra.workManager == null : this.workManager.equals(ra.workManager)) && this.connections.equals(ra.connections)) {
                return true;
            }
        }
        return false;
    }
}

