/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamChunker
implements AutoCloseable {
    private InputStream in;
    private byte[] buffer;
    private static final int bufferSize = 1024;

    public StreamChunker(InputStream in) {
        this.in = in;
        this.buffer = new byte[1024];
    }

    public boolean chunkRemaining() throws IOException {
        return this.in.available() > 0;
    }

    public long writeChunk(OutputStream out, long chunkSize) throws IOException {
        long bytesWritten;
        int b;
        for (bytesWritten = 0L; bytesWritten < chunkSize && (b = this.in.read(this.buffer)) > -1; bytesWritten += (long)b) {
            out.write(this.buffer, 0, b);
        }
        return bytesWritten;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

