/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples;

import de.osci.helper.Tools;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messagetypes.ForwardDelivery;
import de.osci.osci12.messagetypes.GetMessageId;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.messagetypes.StoreDelivery;
import de.osci.osci12.messagetypes.StoredMessage;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.roles.Role;
import de.osci.osci12.samples.impl.HttpTransport;
import de.osci.osci12.samples.impl.crypto.PKCS12Decrypter;
import de.osci.osci12.samples.impl.crypto.PKCS12Signer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;

public class AuthorOriginatorContentInterchange {
    public File createStoredMessageFile(String data, String attachmentFilename) throws Exception {
        DialogHandler clientDialog = new DialogHandler((Originator)null, null, null);
        ForwardDelivery forwardDel = new ForwardDelivery(clientDialog, null, "XX", "YY");
        forwardDel.setQualityOfTimeStampCreation(false);
        forwardDel.setQualityOfTimeStampReception(false);
        ContentContainer encrypted_container = new ContentContainer();
        encrypted_container.addContent(new Content(data));
        String path = Paths.get(attachmentFilename, new String[0]).getParent().toString();
        encrypted_container.addContent(new Content(new Attachment((InputStream)new FileInputStream(attachmentFilename), attachmentFilename.substring(path.length()), "http://www.w3.org/2009/xmlenc11#aes256-gcm")));
        Author author = new Author((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", "123456"), null);
        encrypted_container.sign((Role)author);
        EncryptedDataOSCI encryptedData = new EncryptedDataOSCI("http://www.w3.org/2009/xmlenc11#aes256-gcm", encrypted_container);
        Reader reader = new Reader(Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/dave_cipher_4096.cer")));
        encryptedData.encrypt((Role)reader);
        forwardDel.addEncryptedData(encryptedData);
        File store = new File(path + "/StoredForwardDelivery.osci");
        StoredMessage.storeMessage((OSCIMessage)forwardDel, (OutputStream)new FileOutputStream(store));
        return store;
    }

    public StoreDelivery importToStoreDelivery(String intermedURL, File storedFile) throws Exception {
        Originator user_1 = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", "123456"), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/carol_cipher_4096.p12", "123456"));
        X509Certificate intermedCipherCert = Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer"));
        Intermed intermed = new Intermed(null, intermedCipherCert, new URI(intermedURL));
        DialogHandler clientDialog = new DialogHandler(user_1, intermed, (TransportI)new HttpTransport());
        GetMessageId getMsgID = new GetMessageId(clientDialog);
        ResponseToGetMessageId rsp2GetMsgID = getMsgID.send();
        if (!rsp2GetMsgID.getFeedback()[0][1].startsWith("0")) {
            // empty if block
        }
        Addressee user_2 = new Addressee(null, Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer")));
        StoreDelivery storeDel = new StoreDelivery(clientDialog, user_2, rsp2GetMsgID.getMessageId());
        storeDel.setSubject("Subject");
        storeDel.setQualityOfTimeStampCreation(false);
        storeDel.setQualityOfTimeStampReception(false);
        StoredMessage storedMsg = StoredMessage.loadMessage((InputStream)new FileInputStream(storedFile));
        storeDel.addEncryptedData(storedMsg.getEncryptedData()[0]);
        Reader[] readers = storedMsg.getOtherReaders();
        for (int i = 0; i < readers.length; ++i) {
            storeDel.addRole((Role)readers[i]);
        }
        Author[] authors = storedMsg.getOtherAuthors();
        for (int i = 0; i < authors.length; ++i) {
            storeDel.addRole((Role)authors[i]);
        }
        storedMsg.exportAttachments((OSCIMessage)storeDel);
        ContentContainer not_encrypted_container = new ContentContainer();
        not_encrypted_container.addContent(new Content("Any content data."));
        storeDel.addContentContainer(not_encrypted_container);
        Reader reader = new Reader(Tools.createCertificate((InputStream)this.getClass().getResourceAsStream("/de/osci/osci12/samples/zertifikate/dave_cipher_4096.cer")));
        ContentContainer encrypted_container = new ContentContainer();
        encrypted_container.addContent(new Content("Any encrypted content data."));
        EncryptedDataOSCI encryptedData = new EncryptedDataOSCI("http://www.w3.org/2009/xmlenc11#aes256-gcm", encrypted_container);
        encryptedData.encrypt((Role)reader);
        storeDel.addEncryptedData(encryptedData);
        return storeDel;
    }

    public static void main(String[] args) {
        try {
            String sampleFile;
            String intermedUrl = args.length > 0 && args[0] != null ? args[0] : "http://gov.test.osci.de/osci-manager-entry/externalentry";
            String sampleData = args.length > 1 && args[1] != null ? args[1] : "Beispiel-Daten";
            String string = sampleFile = args.length > 2 ? args[2] : null;
            if (sampleFile == null) {
                File tempFile = File.createTempFile("Beispiel", ".txt");
                tempFile.deleteOnExit();
                sampleFile = tempFile.getAbsolutePath();
            }
            AuthorOriginatorContentInterchange authOrigSample = new AuthorOriginatorContentInterchange();
            File stored = authOrigSample.createStoredMessageFile(sampleData, sampleFile);
            StoreDelivery storeDel = authOrigSample.importToStoreDelivery(intermedUrl, stored);
            System.out.println("\nStoreDelivery-message with imported data:\n" + storeDel.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

