/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.CustomHeaderExtention;
import eu.osci.ws._2014._10.transport.MessageMetaData;
import eu.osci.ws._2014._10.transport.ObjectFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMetaDataCustomHeader
extends CustomHeaderExtention {
    private static final String MESSAGE_META_DATA_ID = "MetaData";
    private MessageMetaData messageMetaData;
    private static Logger log = LoggerFactory.getLogger(MessageMetaDataCustomHeader.class);
    private static JAXBContext jaxbContext;
    private static final XMLInputFactory XML_INPUT_FACTORY;

    public MessageMetaDataCustomHeader(MessageMetaData messageMetaData) {
        this.messageMetaData = messageMetaData;
    }

    public MessageMetaDataCustomHeader() {
    }

    public String getOutgoingHeader() {
        String mmdOsciString = "";
        String mmdStringWithId = MessageMetaDataCustomHeader.addIdToCustomHeader((String)MessageMetaDataCustomHeader.getMessageMetaDataAsString(this.messageMetaData), (String)MESSAGE_META_DATA_ID);
        mmdOsciString = MessageMetaDataCustomHeader.makeOSCICustomHeader((String)mmdStringWithId);
        if (log.isDebugEnabled()) {
            log.debug("get MessageMetaData: " + mmdOsciString);
        }
        return mmdOsciString;
    }

    public MessageMetaData getMessageMetaData() {
        return this.messageMetaData;
    }

    private static String getMessageMetaDataAsString(MessageMetaData mmd) {
        String mmdString = "";
        try {
            ByteArrayOutputStream streamMMD = new ByteArrayOutputStream();
            jaxbContext.createMarshaller().marshal((Object)mmd, (OutputStream)streamMMD);
            mmdString = new String(streamMMD.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            log.warn("Could not add messageMetaData!", (Throwable)ex);
        }
        return mmdString;
    }

    public String getCustomHeaderRefID() {
        return MESSAGE_META_DATA_ID;
    }

    public CustomHeaderExtention parseIncomingHeader(String customHeaderString) throws IOException {
        MessageMetaDataCustomHeader messageMetaDataCustomHeader;
        StringReader in = new StringReader(customHeaderString);
        try {
            this.messageMetaData = (MessageMetaData)jaxbContext.createUnmarshaller().unmarshal(XML_INPUT_FACTORY.createXMLStreamReader(in));
            messageMetaDataCustomHeader = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException | XMLStreamException ex) {
                throw new IOException(ex);
            }
        }
        ((Reader)in).close();
        return messageMetaDataCustomHeader;
    }

    static {
        XML_INPUT_FACTORY = XMLInputFactory.newFactory();
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", false);
        }
        catch (JAXBException e) {
            log.error("Cannot create JAXB Context for MessageMetaData, handling MessageMetaData will be impossible", (Throwable)e);
        }
    }
}

