/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.Tools;
import de.osci.osci12.messageparts.MessageMetaDataCustomHeader;
import eu.osci.ws._2014._10.transport.DeliveryAttributesType;
import eu.osci.ws._2014._10.transport.DestinationsType;
import eu.osci.ws._2014._10.transport.KeyCodeType;
import eu.osci.ws._2014._10.transport.MessageMetaData;
import eu.osci.ws._2014._10.transport.MsgIdentificationType;
import eu.osci.ws._2014._10.transport.OriginatorsType;
import eu.osci.ws._2014._10.transport.PartyIdentifierType;
import eu.osci.ws._2014._10.transport.PartyType;
import eu.osci.ws._2014._10.transport.QualifierType;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCustomHeaderHelper {
    private static Logger log = LoggerFactory.getLogger(TestCustomHeaderHelper.class);
    private static String mmdTestFile;

    @BeforeClass
    public static void setUp() throws IOException {
        mmdTestFile = new String(Tools.readBytes((InputStream)TestCustomHeaderHelper.class.getResourceAsStream("/xtaMmdOsci.xml")));
    }

    @Test
    public void testReadTestFile() throws Exception {
        MessageMetaDataCustomHeader mmdExtention = new MessageMetaDataCustomHeader();
        mmdExtention.parseIncomingHeader(mmdTestFile);
        Assert.assertEquals((Object)BigInteger.valueOf(7478L), (Object)mmdExtention.getMessageMetaData().getMsgSize());
        Assert.assertEquals((Object)"meldewesen", (Object)mmdExtention.getMessageMetaData().getDeliveryAttributes().getServiceQuality());
    }

    @Test
    public void testCreateWithAndWithoutId() throws Exception {
        MessageMetaDataCustomHeader mmdExtention = new MessageMetaDataCustomHeader();
        mmdExtention.parseIncomingHeader(mmdTestFile);
        MessageMetaData mmd = mmdExtention.getMessageMetaData();
        Assert.assertFalse((boolean)mmdTestFile.contains("Id=\"" + mmdExtention.getCustomHeaderRefID() + "\""));
        Assert.assertTrue((boolean)mmdExtention.getOutgoingHeader().contains("Id=\"" + mmdExtention.getCustomHeaderRefID() + "\""));
    }

    @Test
    public void testReadWriteMMD() throws Exception {
        MessageMetaData mmd = new MessageMetaData();
        mmd.setDeliveryAttributes(new DeliveryAttributesType());
        mmd.getDeliveryAttributes().setServiceQuality("maulwurfwesen");
        mmd.setMsgSize(BigInteger.valueOf(12345L));
        String mmdString = new MessageMetaDataCustomHeader(mmd).getOutgoingHeader();
        Assert.assertTrue((boolean)mmdString.contains(":DeliveryAttributes>"));
        Assert.assertTrue((boolean)mmdString.contains(":ServiceQuality>maulwurfwesen</"));
        Assert.assertTrue((boolean)mmdString.contains(":MsgSize>12345</"));
        MessageMetaDataCustomHeader mmdParsed = new MessageMetaDataCustomHeader();
        mmdParsed.parseIncomingHeader(mmdString);
        MessageMetaData mmdRead = mmdParsed.getMessageMetaData();
        Assert.assertEquals((Object)BigInteger.valueOf(12345L), (Object)mmdRead.getMsgSize());
        Assert.assertEquals((Object)"maulwurfwesen", (Object)mmdRead.getDeliveryAttributes().getServiceQuality());
    }

    public static MessageMetaData createTestMMD() {
        MessageMetaData mmd = new MessageMetaData();
        mmd.setDeliveryAttributes(new DeliveryAttributesType());
        mmd.getDeliveryAttributes().setServiceQuality("meldewesen");
        mmd.setOriginators(new OriginatorsType());
        PartyIdentifierType type = new PartyIdentifierType();
        type.setName("Ralf Lindemann");
        type.setType("xoev");
        type.setValue("ags:02044096");
        PartyType party = new PartyType();
        party.setIdentifier(type);
        mmd.getOriginators().setAuthor(party);
        type = new PartyIdentifierType();
        type.setName("Gov Infra Test Server");
        type.setType("xoev");
        type.setValue("ags:0403014096");
        party = new PartyType();
        party.setIdentifier(type);
        mmd.setDestinations(new DestinationsType());
        mmd.getDestinations().setReader(party);
        AttributedURIType msgId = new AttributedURIType();
        msgId.setValue("urn:de:xta:messageid:TestXTAgovernikus:213cd4be-67c1-44ad-9fff-46da9b73b0eb");
        mmd.setMsgIdentification(new MsgIdentificationType());
        mmd.getMsgIdentification().setMessageID(msgId);
        QualifierType.BusinessScenario bs = new QualifierType.BusinessScenario();
        KeyCodeType kct = new KeyCodeType();
        kct.setListURI("urn:de:xta:codeliste:business.scenario");
        kct.setListVersionID("2");
        kct.setCode("XINNERES_DATA");
        bs.setDefined(kct);
        QualifierType.MessageType msgType = new QualifierType.MessageType();
        msgType.setListURI("urn:de:codeliste:nachrichtentyp");
        msgType.setListVersionID("1");
        msgType.setPayloadSchema("http://www.osci.de/xinneres/rueckweisung/3/xinneres-rueckweisung.xsd");
        msgType.setCode("rueckweisung.asynchron.0010");
        msgType.setName("XInneres-Rueckweisung");
        QualifierType qualifier = new QualifierType();
        qualifier.setService("http://www.osci.de/xinneres/rueckweisung/3/xinneresrueckweisungv3.wsdl");
        qualifier.setBusinessScenario(bs);
        mmd.setMsgSize(BigInteger.valueOf(12345L));
        return mmd;
    }
}

