/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messageparts;

import de.osci.helper.CustomHeaderExtention;
import de.osci.helper.Tools;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.MessageMetaDataCustomHeader;
import de.osci.osci12.messagetypes.ExitDialog;
import de.osci.osci12.messagetypes.FetchDelivery;
import de.osci.osci12.messagetypes.GetMessageId;
import de.osci.osci12.messagetypes.InitDialog;
import de.osci.osci12.messagetypes.ResponseToFetchDelivery;
import de.osci.osci12.messagetypes.ResponseToGetMessageId;
import de.osci.osci12.messagetypes.StoreDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.samples.impl.HttpTransport;
import de.osci.osci12.samples.impl.crypto.PKCS12Decrypter;
import de.osci.osci12.samples.impl.crypto.PKCS12Signer;
import eu.osci.ws._2014._10.transport.DeliveryAttributesType;
import eu.osci.ws._2014._10.transport.DestinationsType;
import eu.osci.ws._2014._10.transport.KeyCodeType;
import eu.osci.ws._2014._10.transport.MessageMetaData;
import eu.osci.ws._2014._10.transport.MsgIdentificationType;
import eu.osci.ws._2014._10.transport.OriginatorsType;
import eu.osci.ws._2014._10.transport.PartyIdentifierType;
import eu.osci.ws._2014._10.transport.PartyType;
import eu.osci.ws._2014._10.transport.QualifierType;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.cxf.ws.addressing.AttributedURIType;

public class SendMessageWithMessageMetaData {
    private static final String PIN = "123456";

    public static void main(String[] args) throws Exception {
        MessageMetaData mmd = SendMessageWithMessageMetaData.createSampleMMD();
        String messageId = SendMessageWithMessageMetaData.sendStoreDeliveryWithMessageMetaData(new MessageMetaDataCustomHeader(mmd));
        SendMessageWithMessageMetaData.fetchMessageAndCheckMessageMetaData(messageId);
    }

    private static String sendStoreDeliveryWithMessageMetaData(MessageMetaDataCustomHeader mmd) throws Exception {
        System.out.println("Bereite OSCI-StoreDelivery-Transport vor");
        DialogHandler senderDialog = SendMessageWithMessageMetaData.createSendDialogHandler();
        Addressee addressee = SendMessageWithMessageMetaData.createAddressee();
        String msgId = SendMessageWithMessageMetaData.getMsgId(senderDialog);
        StoreDelivery storeDelivery = new StoreDelivery(senderDialog, addressee, msgId);
        System.out.println("F\u00fcge der Nachricht das MessageMetaData-Element als CustomHeader hinzu");
        storeDelivery.addCustomHeaderExtention((CustomHeaderExtention)mmd);
        System.out.println("Versende OSCI-StoreDelivery-Nachricht an Intermedi\u00e4r");
        return storeDelivery.send().getMessageId();
    }

    private static void fetchMessageAndCheckMessageMetaData(String messageId) throws Exception {
        System.out.println("Bereite OSCI-FetchDelivery-Transport vor");
        DialogHandler fetchDialog = SendMessageWithMessageMetaData.createFetchDialogHandler();
        new InitDialog(fetchDialog).send();
        System.out.println("Erzeuge und versende FetchDelivery-Nachricht");
        FetchDelivery fetchDel = new FetchDelivery(fetchDialog);
        fetchDel.setSelectionMode(0);
        fetchDel.setSelectionRule(messageId);
        ResponseToFetchDelivery rsp2FetchDel = fetchDel.send();
        MessageMetaDataCustomHeader mmd = (MessageMetaDataCustomHeader)rsp2FetchDel.getCustomHeader((CustomHeaderExtention)new MessageMetaDataCustomHeader());
        if (mmd.getMessageMetaData().getMsgIdentification().getMessageID().getValue().equals("urn:de:xta:messageid:TestXTAgovernikus:8dfasdf-67c1-44ad-dfss-46da9b73b0eb")) {
            System.out.println("Abgeholte Nachricht enth\u00e4lt MessageMetaData-Element mit der korrekten ID");
        } else {
            System.err.println("Abgeholte Nachricht enth\u00e4lt MessageMetaData-Element mit der falschen ID!");
        }
        new ExitDialog(fetchDialog).send();
    }

    private static DialogHandler createSendDialogHandler() throws Exception {
        Intermed intermed = SendMessageWithMessageMetaData.createIntermed();
        Originator originator = SendMessageWithMessageMetaData.createOriginator();
        return new DialogHandler(originator, intermed, (TransportI)new HttpTransport());
    }

    private static DialogHandler createFetchDialogHandler() throws Exception {
        Intermed intermed = SendMessageWithMessageMetaData.createIntermed();
        Originator originator = new Originator((Signer)new PKCS12Signer("/de/osci/osci12/samples/zertifikate/bob_signature_4096.p12", PIN), (Decrypter)new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.p12", PIN));
        return new DialogHandler(originator, intermed, (TransportI)new HttpTransport());
    }

    private static Intermed createIntermed() throws CertificateException, URISyntaxException {
        X509Certificate cipherCert = SendMessageWithMessageMetaData.createIntermedCipherCert();
        URI uri = SendMessageWithMessageMetaData.createIntermedUri();
        return new Intermed(null, cipherCert, uri);
    }

    private static X509Certificate createIntermedCipherCert() throws CertificateException {
        String testCypher = "/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer";
        InputStream resource = SendMessageWithMessageMetaData.getResource("/de/osci/osci12/samples/zertifikate/osci_manager_cipher_4096.cer");
        return Tools.createCertificate((InputStream)resource);
    }

    private static InputStream getResource(String resource) {
        return SendMessageWithMessageMetaData.class.getResourceAsStream(resource);
    }

    private static URI createIntermedUri() throws URISyntaxException {
        String testEntry = "http://gov.test.osci.de/osci-manager-entry/externalentry";
        return new URI("http://gov.test.osci.de/osci-manager-entry/externalentry");
    }

    private static Originator createOriginator() throws Exception {
        Signer signer = SendMessageWithMessageMetaData.createSigner();
        PKCS12Decrypter decrypter = new PKCS12Decrypter("/de/osci/osci12/samples/zertifikate/alice_cipher_4096.p12", PIN);
        return new Originator(signer, (Decrypter)decrypter);
    }

    private static Signer createSigner() throws Exception {
        String cert = "/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12";
        return new PKCS12Signer("/de/osci/osci12/samples/zertifikate/alice_signature_4096.p12", PIN);
    }

    private static Addressee createAddressee() throws CertificateException {
        String cert = "/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer";
        InputStream resource = SendMessageWithMessageMetaData.getResource("/de/osci/osci12/samples/zertifikate/bob_cipher_4096.cer");
        return new Addressee(null, Tools.createCertificate((InputStream)resource));
    }

    private static String getMsgId(DialogHandler dh) throws Exception {
        GetMessageId getMsgId = new GetMessageId(dh);
        ResponseToGetMessageId rsp2GetMsgID = getMsgId.send();
        return rsp2GetMsgID.getMessageId();
    }

    private static MessageMetaData createSampleMMD() {
        MessageMetaData mmd = new MessageMetaData();
        mmd.setDeliveryAttributes(new DeliveryAttributesType());
        mmd.getDeliveryAttributes().setServiceQuality("meldewesen");
        mmd.setOriginators(new OriginatorsType());
        PartyIdentifierType type = new PartyIdentifierType();
        type.setName("Author");
        type.setType("xoev");
        type.setValue("ags:01010101010");
        PartyType party = new PartyType();
        party.setIdentifier(type);
        mmd.getOriginators().setAuthor(party);
        type = new PartyIdentifierType();
        type.setName("Reader");
        type.setType("xoev");
        type.setValue("ags:01010101010");
        party = new PartyType();
        party.setIdentifier(type);
        mmd.setDestinations(new DestinationsType());
        mmd.getDestinations().setReader(party);
        AttributedURIType msgId = new AttributedURIType();
        msgId.setValue("urn:de:xta:messageid:TestXTAgovernikus:8dfasdf-67c1-44ad-dfss-46da9b73b0eb");
        mmd.setMsgIdentification(new MsgIdentificationType());
        mmd.getMsgIdentification().setMessageID(msgId);
        QualifierType.BusinessScenario bs = new QualifierType.BusinessScenario();
        KeyCodeType kct = new KeyCodeType();
        kct.setListURI("urn:de:xta:codeliste:business.scenario");
        kct.setListVersionID("2");
        kct.setCode("XINNERES_DATA");
        bs.setDefined(kct);
        QualifierType.MessageType msgType = new QualifierType.MessageType();
        msgType.setListURI("urn:de:codeliste:nachrichtentyp");
        msgType.setListVersionID("1");
        msgType.setPayloadSchema("http://www.osci.de/xinneres/rueckweisung/3/xinneres-rueckweisung.xsd");
        msgType.setCode("rueckweisung.asynchron.0010");
        msgType.setName("XInneres-Rueckweisung");
        QualifierType qualifier = new QualifierType();
        qualifier.setService("http://www.osci.de/xinneres/rueckweisung/3/xinneresrueckweisungv3.wsdl");
        qualifier.setBusinessScenario(bs);
        mmd.setMsgSize(BigInteger.valueOf(12345L));
        return mmd;
    }
}

