/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.user;

import de.openknowledge.authentication.domain.Password;
import de.openknowledge.authentication.domain.UserIdentifier;
import de.openknowledge.authentication.domain.Username;
import de.openknowledge.authentication.domain.registration.Issuer;
import de.openknowledge.authentication.domain.token.Token;
import de.openknowledge.authentication.domain.user.Attribute;
import de.openknowledge.authentication.domain.user.EmailAddress;
import de.openknowledge.authentication.domain.user.FirstName;
import de.openknowledge.authentication.domain.user.LastName;
import de.openknowledge.authentication.domain.user.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.keycloak.representations.idm.UserRepresentation;

public class UserAccount {
    private final Username username;
    private final Password password;
    private final EmailAddress emailAddress;
    private final List<Attribute> attributes;
    private UserIdentifier identifier;
    private Name name;
    private Boolean emailVerified;

    public UserAccount(UserIdentifier theIdentifier, EmailAddress theEmailAddress) {
        this(theIdentifier, Username.fromValue((String)theEmailAddress.getValue()), theEmailAddress, null);
    }

    public UserAccount(UserIdentifier theIdentifier, Username theUsername, EmailAddress theEmailAddress) {
        this(theIdentifier, theUsername, theEmailAddress, null);
    }

    public UserAccount(UserIdentifier theIdentifier, EmailAddress theEmailAddress, Password thePassword) {
        this(theIdentifier, Username.fromValue((String)theEmailAddress.getValue()), theEmailAddress, thePassword);
    }

    public UserAccount(Username theUsername, EmailAddress theEmailAddress) {
        this(null, theUsername, theEmailAddress, null);
    }

    public UserAccount(Username theUsername, EmailAddress theEmailAddress, Password thePassword) {
        this(null, theUsername, theEmailAddress, thePassword);
    }

    public UserAccount(EmailAddress theEmailAddress) {
        this(null, Username.fromValue((String)theEmailAddress.getValue()), theEmailAddress, null);
    }

    public UserAccount(EmailAddress theEmailAddress, Password thePassword) {
        this(null, Username.fromValue((String)theEmailAddress.getValue()), theEmailAddress, thePassword);
    }

    public UserAccount(UserIdentifier theIdentifier, Username theUsername, EmailAddress theEmailAddress, Password thePassword) {
        this.identifier = theIdentifier;
        this.username = theUsername;
        this.emailAddress = theEmailAddress;
        this.password = thePassword;
        this.attributes = new ArrayList<Attribute>();
        this.emailVerified = Boolean.FALSE;
    }

    UserAccount(UserRepresentation user) {
        this(UserIdentifier.fromValue(user.getId()), Username.fromValue(user.getUsername()), EmailAddress.fromValue(user.getEmail()), null);
        this.createName(user);
        if (user.isEmailVerified() != null && user.isEmailVerified().booleanValue()) {
            this.emailVerified();
        }
        if (user.getAttributes() != null) {
            this.convertMapToAttributes(user.getAttributes());
        }
    }

    Boolean isDifferent(UserAccount account) {
        return !this.getEmailAddress().equals(account.getEmailAddress()) || !this.getUsername().equals(account.getUsername()) || this.getName() != null && !this.getName().equals(account.getName()) || this.getName() == null && account.getName() != null || !this.getEmailVerified().equals(account.getEmailVerified());
    }

    UserRepresentation asRepresentation(Boolean newObject) {
        UserRepresentation keycloakUser = new UserRepresentation();
        keycloakUser.setUsername((String)this.getUsername().getValue());
        keycloakUser.setEmail((String)this.getEmailAddress().getValue());
        keycloakUser.setEnabled(Boolean.valueOf(true));
        if (this.getIdentifier() != null) {
            keycloakUser.setId((String)this.getIdentifier().getValue());
        }
        if (this.getName() != null && this.getName().getFirstName() != null) {
            keycloakUser.setFirstName((String)this.getName().getFirstName().getValue());
        }
        if (this.getName() != null && this.getName().getLastName() != null) {
            keycloakUser.setLastName((String)this.getName().getLastName().getValue());
        }
        keycloakUser.setEmailVerified(this.getEmailVerified());
        keycloakUser.setAttributes(this.convertAttributesToMap());
        if (newObject.booleanValue() && this.getPassword() != null) {
            keycloakUser.setCredentials(Collections.singletonList(this.getPassword().asCredential()));
        }
        return keycloakUser;
    }

    public Token asToken(Issuer issuer) {
        return this.asToken(issuer, 5, TimeUnit.MINUTES);
    }

    public Token asToken(Issuer issuer, Integer timeToLive) {
        return this.asToken(issuer, timeToLive, TimeUnit.MINUTES);
    }

    public Token asToken(Issuer issuer, Integer timeToLive, TimeUnit timeUnit) {
        return new Token(this.username, this.identifier, this.emailAddress, issuer, timeToLive, timeUnit);
    }

    public UserIdentifier getIdentifier() {
        return this.identifier;
    }

    public Username getUsername() {
        return this.username;
    }

    public Password getPassword() {
        return this.password;
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public Name getName() {
        return this.name;
    }

    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    void bindTo(UserIdentifier anIdentifier) {
        Validate.notNull((Object)anIdentifier, (String)"identifier may not be null", (Object[])new Object[0]);
        this.identifier = anIdentifier;
    }

    public void setName(Name aName) {
        Validate.notNull((Object)aName, (String)"name may not be null", (Object[])new Object[0]);
        this.name = aName;
    }

    public void addAttribute(Attribute theAttribute) {
        Validate.notNull((Object)theAttribute, (String)"attribute may not be null", (Object[])new Object[0]);
        this.attributes.add(theAttribute);
    }

    public void emailVerified() {
        this.emailVerified = Boolean.TRUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserAccount)) {
            return false;
        }
        UserAccount that = (UserAccount)o;
        return Objects.equals(this.getIdentifier(), that.getIdentifier()) && Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getPassword(), that.getPassword()) && Objects.equals(this.getEmailAddress(), that.getEmailAddress()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getEmailVerified(), that.getEmailVerified()) && Objects.equals(this.getAttributes(), that.getAttributes());
    }

    public int hashCode() {
        return Objects.hash(this.getIdentifier(), this.getUsername(), this.getPassword(), this.getEmailAddress(), this.getName(), this.getEmailVerified(), this.getAttributes());
    }

    public String toString() {
        return "UserAccount{identifier=" + this.identifier + ", username=" + this.username + ", password=******, emailAddress=" + this.emailAddress + ", emailVerified=" + this.emailVerified + ", name=" + this.name + ", attributes=" + this.attributes + "}";
    }

    private void createName(UserRepresentation user) {
        LastName lastName;
        FirstName firstName = user.getFirstName() != null ? FirstName.fromValue(user.getFirstName()) : null;
        LastName lastName2 = lastName = user.getLastName() != null ? LastName.fromValue(user.getLastName()) : null;
        if (firstName != null && lastName != null) {
            this.setName(Name.fromValues(firstName, lastName));
        } else if (firstName != null) {
            this.setName(Name.fromValue(firstName));
        } else if (lastName != null) {
            this.setName(Name.fromValue(lastName));
        }
    }

    private Map<String, List<String>> convertAttributesToMap() {
        HashMap<String, List<String>> userAttributeMap = new HashMap<String, List<String>>();
        for (Attribute attribute : this.getAttributes()) {
            List<String> userAttributeList = userAttributeMap.containsKey(attribute.getKey()) ? (List)userAttributeMap.get(attribute.getKey()) : new ArrayList<String>();
            userAttributeList.add(attribute.getValue());
            userAttributeMap.put(attribute.getKey(), userAttributeList);
        }
        return userAttributeMap;
    }

    private void convertMapToAttributes(Map<String, List<String>> attributeMap) {
        for (Map.Entry<String, List<String>> entry : attributeMap.entrySet()) {
            for (String value : entry.getValue()) {
                this.addAttribute(new Attribute(entry.getKey(), value));
            }
        }
    }
}

