/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.token;

import de.openknowledge.authentication.domain.InvalidConfigurationException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class KeycloakKeyConfiguration {
    private static final String FILENAME_PUB_KEY_PROPERTY = "keycloak.keyPair.filename.publicKey";
    private static final String FILENAME_PRI_KEY_PROPERTY = "keycloak.keyPair.filename.privateKey";
    private static final String TOKEN_SECRET_PROPERTY = "keycloak.keyPair.tokenSecret";
    private static final String ALGORITHM_PROPERTY = "keycloak.keyPair.algorithm";
    private static final String FILENAME_PUB_KEY_DEFAULT = "missingPathToPublicKey";
    private static final String FILENAME_PRI_KEY_DEFAULT = "missingPathToPrivateKey";
    private static final String TOKEN_SECRET_DEFAULT = "missingTokenSecret";
    private static final String ALGORITHM_DEFAULT = "RSA";
    private String filenamePublicKey;
    private String filenamePrivateKey;
    private String tokenSecret;
    private String algorithm;

    protected KeycloakKeyConfiguration() {
    }

    @Inject
    public KeycloakKeyConfiguration(@ConfigProperty(name="keycloak.keyPair.filename.publicKey", defaultValue="missingPathToPublicKey") String aFilenamePublicKey, @ConfigProperty(name="keycloak.keyPair.filename.privateKey", defaultValue="missingPathToPrivateKey") String aFilenamePrivateKey, @ConfigProperty(name="keycloak.keyPair.tokenSecret", defaultValue="missingTokenSecret") String aTokenSecret, @ConfigProperty(name="keycloak.keyPair.algorithm", defaultValue="RSA") String anAlgorithm) {
        this.filenamePublicKey = aFilenamePublicKey;
        this.filenamePrivateKey = aFilenamePrivateKey;
        this.tokenSecret = aTokenSecret;
        this.algorithm = anAlgorithm;
    }

    public String getFilenamePublicKey() {
        return this.filenamePublicKey;
    }

    public String getFilenamePrivateKey() {
        return this.filenamePrivateKey;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    void validate() {
        if (TOKEN_SECRET_DEFAULT.equals(this.getTokenSecret())) {
            throw new InvalidConfigurationException(TOKEN_SECRET_PROPERTY);
        }
        if (FILENAME_PRI_KEY_DEFAULT.equals(this.getFilenamePrivateKey())) {
            throw new InvalidConfigurationException(FILENAME_PRI_KEY_PROPERTY);
        }
        if (FILENAME_PUB_KEY_DEFAULT.equals(this.getFilenamePublicKey())) {
            throw new InvalidConfigurationException(FILENAME_PRI_KEY_PROPERTY);
        }
    }
}

