/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.realm;

import de.openknowledge.authentication.domain.KeycloakAdapter;
import de.openknowledge.authentication.domain.RealmName;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.keycloak.representations.idm.RealmRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakRealmService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakRealmService.class);
    private KeycloakAdapter keycloakAdapter;

    protected KeycloakRealmService() {
    }

    @Inject
    public KeycloakRealmService(KeycloakAdapter aKeycloakAdapter) {
        this.keycloakAdapter = aKeycloakAdapter;
    }

    public List<RealmName> getRealms() {
        List<RealmName> realmNames = new ArrayList<RealmName>();
        List<RealmRepresentation> realms = this.keycloakAdapter.findAll();
        if (!realms.isEmpty()) {
            realmNames = realms.stream().map(RealmRepresentation::getRealm).map(RealmName::fromValue).collect(Collectors.toList());
        }
        return realmNames;
    }
}

