/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain;

import de.openknowledge.authentication.domain.ClientId;
import de.openknowledge.authentication.domain.KeycloakAdapterConfiguration;
import de.openknowledge.authentication.domain.RealmName;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.admin.client.token.TokenService;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;

@ApplicationScoped
public class KeycloakAdapter {
    private Keycloak keycloak;
    private TokenService tokenService;

    protected KeycloakAdapter() {
    }

    @Inject
    public KeycloakAdapter(KeycloakAdapterConfiguration adapterConfig) {
        ResteasyClient restClient = new ResteasyClientBuilder().connectionPoolSize(adapterConfig.getConnectionPoolSize().intValue()).build();
        this.keycloak = KeycloakBuilder.builder().serverUrl(adapterConfig.getServerUrl()).realm(adapterConfig.getMasterRealm()).grantType(adapterConfig.getGrantType()).username(adapterConfig.getUsername()).password(adapterConfig.getPassword()).clientId(adapterConfig.getClientId()).resteasyClient(restClient).build();
        this.tokenService = (TokenService)restClient.target(adapterConfig.getServerUrl()).proxy(TokenService.class);
    }

    public List<RealmRepresentation> findAll() {
        RealmsResource realmsResource = this.keycloak.realms();
        return realmsResource.findAll();
    }

    public RealmResource findRealmResource(RealmName realmName) {
        return this.keycloak.realm((String)realmName.getValue());
    }

    public ClientsResource findClientsResource(RealmName realmName) {
        return this.findRealmResource(realmName).clients();
    }

    public ClientResource findClientResource(RealmName realmName, ClientId clientId) {
        ClientsResource clientsResource = this.findClientsResource(realmName);
        String clientUuid = this.findClientUuid(clientsResource, clientId);
        return clientsResource.get(clientUuid);
    }

    public UsersResource findUsersResource(RealmName realmName) {
        RealmResource realmResource = this.findRealmResource(realmName);
        return realmResource.users();
    }

    public GroupsResource findGroupsResource(RealmName realmName) {
        RealmResource realmResource = this.findRealmResource(realmName);
        return realmResource.groups();
    }

    public RolesResource findRealmRolesResource(RealmName realmName) {
        RealmResource realmResource = this.findRealmResource(realmName);
        return realmResource.roles();
    }

    public RolesResource findClientRolesResource(RealmName realmName, ClientId clientId) {
        ClientResource clientResource = this.findClientResource(realmName, clientId);
        return clientResource.roles();
    }

    public String findClientUuid(RealmName realmName, ClientId clientId) {
        ClientsResource clientsResource = this.findClientsResource(realmName);
        return this.findClientUuid(clientsResource, clientId);
    }

    public String findClientUuid(ClientsResource clientsResource, ClientId clientId) {
        List clientRepresentations = clientsResource.findByClientId((String)clientId.getValue());
        if (clientRepresentations.isEmpty()) {
            throw new NotFoundException("client not found for clientId '" + clientId + "'");
        }
        return ((ClientRepresentation)clientRepresentations.stream().findFirst().get()).getId();
    }

    public TokenService getTokenService() {
        return this.tokenService;
    }
}

