/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.user;

import de.openknowledge.authentication.domain.user.FirstName;
import de.openknowledge.authentication.domain.user.LastName;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class Name {
    private FirstName firstName;
    private LastName lastName;

    private Name(FirstName aFirstName, LastName aLastName) {
        this.firstName = aFirstName;
        this.lastName = aLastName;
    }

    protected Name() {
    }

    public static Name fromValues(FirstName firstName, LastName lastName) {
        Validate.notNull((Object)firstName, (String)"firstName may not be null", (Object[])new Object[0]);
        Validate.notNull((Object)lastName, (String)"lastName may not be null", (Object[])new Object[0]);
        return new Name(firstName, lastName);
    }

    public static Name fromValue(FirstName firstName) {
        Validate.notNull((Object)firstName, (String)"firstName may not be null", (Object[])new Object[0]);
        return new Name(firstName, null);
    }

    public static Name fromValue(LastName lastName) {
        Validate.notNull((Object)lastName, (String)"lastName may not be null", (Object[])new Object[0]);
        return new Name(null, lastName);
    }

    public FirstName getFirstName() {
        return this.firstName;
    }

    public LastName getLastName() {
        return this.lastName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name name = (Name)o;
        return Objects.equals(this.getFirstName(), name.getFirstName()) && Objects.equals(this.getLastName(), name.getLastName());
    }

    public int hashCode() {
        return Objects.hash(this.getFirstName(), this.getLastName());
    }

    public String toString() {
        if (this.firstName != null && this.lastName != null) {
            return this.firstName + " " + this.lastName;
        }
        if (this.firstName == null) {
            return "" + this.lastName;
        }
        return "" + this.firstName;
    }
}

