/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.user;

import de.openknowledge.authentication.domain.ClientId;
import de.openknowledge.authentication.domain.KeycloakAdapter;
import de.openknowledge.authentication.domain.KeycloakServiceConfiguration;
import de.openknowledge.authentication.domain.Password;
import de.openknowledge.authentication.domain.RealmName;
import de.openknowledge.authentication.domain.UserIdentifier;
import de.openknowledge.authentication.domain.error.ResponseErrorMessage;
import de.openknowledge.authentication.domain.group.GroupId;
import de.openknowledge.authentication.domain.group.GroupName;
import de.openknowledge.authentication.domain.role.RoleName;
import de.openknowledge.authentication.domain.role.RoleType;
import de.openknowledge.authentication.domain.user.EmailVerifiedMode;
import de.openknowledge.authentication.domain.user.UserAccount;
import de.openknowledge.authentication.domain.user.UserCreationFailedException;
import de.openknowledge.authentication.domain.user.UserDeletionFailedException;
import de.openknowledge.authentication.domain.user.UserNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakUserService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakUserService.class);
    private KeycloakAdapter keycloakAdapter;
    private KeycloakServiceConfiguration serviceConfiguration;

    protected KeycloakUserService() {
    }

    @Inject
    public KeycloakUserService(KeycloakAdapter aKeycloakAdapter, KeycloakServiceConfiguration aServiceConfiguration) {
        this.keycloakAdapter = aKeycloakAdapter;
        this.serviceConfiguration = aServiceConfiguration;
    }

    @PostConstruct
    public void init() {
        LOG.debug("check configuration");
        this.serviceConfiguration.validate();
    }

    public boolean checkAlreadyExist(UserAccount account) {
        Validate.notNull((Object)account, (String)"account may be not null", (Object[])new Object[0]);
        UsersResource usersResource = this.keycloakAdapter.findUsersResource(this.getRealmName());
        List existingUsersByUsername = usersResource.search((String)account.getUsername().getValue(), Integer.valueOf(0), Integer.valueOf(1));
        LOG.debug("User already exists because result list is not empty (size is: {})", existingUsersByUsername != null ? Integer.valueOf(existingUsersByUsername.size()) : "null");
        return existingUsersByUsername != null && !existingUsersByUsername.isEmpty();
    }

    public UserAccount createUser(UserAccount account, EmailVerifiedMode mode) throws UserCreationFailedException {
        Validate.notNull((Object)account, (String)"account may be not null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)mode), (String)"mode may be not null", (Object[])new Object[0]);
        if (EmailVerifiedMode.DEFAULT.equals((Object)mode)) {
            account.emailVerified();
        }
        UserRepresentation newUser = account.asRepresentation(Boolean.TRUE);
        Response response = this.keycloakAdapter.findUsersResource(this.getRealmName()).create(newUser);
        if (response.getStatus() != 201) {
            ResponseErrorMessage message = (ResponseErrorMessage)response.readEntity(ResponseErrorMessage.class);
            throw new UserCreationFailedException(newUser.getUsername(), response.getStatus(), message.getErrorMessage());
        }
        String path = response.getLocation().getPath();
        String userId = path.replaceAll(".*/([^/]+)$", "$1");
        UserIdentifier identifier = UserIdentifier.fromValue(userId);
        account.setIdentifier(identifier);
        return account;
    }

    public UserAccount getUser(UserIdentifier identifier) throws UserNotFoundException {
        Validate.notNull((Object)identifier, (String)"identifier may be not null", (Object[])new Object[0]);
        try {
            UserResource userResource = this.keycloakAdapter.findUsersResource(this.getRealmName()).get((String)identifier.getValue());
            return new UserAccount(userResource.toRepresentation());
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(identifier, e);
        }
    }

    public void updateUser(UserAccount account) throws UserNotFoundException {
        Validate.notNull((Object)account, (String)"account may be not null", (Object[])new Object[0]);
        UserIdentifier identifier = account.getIdentifier();
        try {
            UserResource resource = this.keycloakAdapter.findUsersResource(this.getRealmName()).get((String)identifier.getValue());
            UserAccount user = new UserAccount(resource.toRepresentation());
            if (user.isDifferent(account).booleanValue()) {
                UserRepresentation updateUser = account.asRepresentation(Boolean.FALSE);
                resource.update(updateUser);
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(identifier, e);
        }
    }

    public void resetPassword(UserIdentifier identifier, Password password) throws UserNotFoundException {
        Validate.notNull((Object)identifier, (String)"identifier may be not null", (Object[])new Object[0]);
        try {
            UserResource resource = this.keycloakAdapter.findUsersResource(this.getRealmName()).get((String)identifier.getValue());
            resource.resetPassword(password.asCredential());
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(identifier, e);
        }
    }

    public void deleteUser(UserIdentifier identifier) {
        Validate.notNull((Object)identifier, (String)"identifier may be not null", (Object[])new Object[0]);
        Response response = this.keycloakAdapter.findUsersResource(this.getRealmName()).delete((String)identifier.getValue());
        if (response.getStatus() != 204 && response.getStatus() != 404) {
            throw new UserDeletionFailedException((String)identifier.getValue(), response.getStatus());
        }
    }

    public void updateMailVerification(UserIdentifier identifier) throws UserNotFoundException {
        Validate.notNull((Object)identifier, (String)"identifier may be not null", (Object[])new Object[0]);
        try {
            UserResource userResource = this.keycloakAdapter.findUsersResource(this.getRealmName()).get((String)identifier.getValue());
            UserRepresentation user = userResource.toRepresentation();
            user.setEmailVerified(Boolean.valueOf(true));
            userResource.update(user);
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(identifier, e);
        }
    }

    public void joinGroups(UserIdentifier identifier, GroupName ... groupNames) throws UserNotFoundException {
        Validate.notNull((Object)identifier, (String)"identifier may be not null", (Object[])new Object[0]);
        try {
            UserResource userResource = this.keycloakAdapter.findUsersResource(this.getRealmName()).get((String)identifier.getValue());
            List<GroupId> joiningGroups = this.findGroupIds(groupNames);
            for (GroupId groupId : joiningGroups) {
                userResource.joinGroup((String)groupId.getValue());
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(identifier, e);
        }
    }

    public void leaveGroups(UserIdentifier identifier, GroupName ... groupNames) throws UserNotFoundException {
        Validate.notNull((Object)identifier, (String)"identifier may be not null", (Object[])new Object[0]);
        try {
            UserResource userResource = this.keycloakAdapter.findUsersResource(this.getRealmName()).get((String)identifier.getValue());
            List<GroupId> leavingGroups = this.findGroupIds(groupNames);
            for (GroupId groupId : leavingGroups) {
                userResource.leaveGroup((String)groupId.getValue());
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(identifier, e);
        }
    }

    public void joinRoles(UserIdentifier identifier, RoleType roleType, RoleName ... roleNames) throws UserNotFoundException {
        Validate.notNull((Object)identifier, (String)"identifier may be not null", (Object[])new Object[0]);
        try {
            UserResource userResource = this.keycloakAdapter.findUsersResource(this.getRealmName()).get((String)identifier.getValue());
            List<RoleRepresentation> joiningRoles = this.findRoles(this.getRolesResource(roleType), roleNames);
            switch (roleType) {
                case REALM: {
                    userResource.roles().realmLevel().add(joiningRoles);
                    break;
                }
                case CLIENT: {
                    String clientUuid = this.keycloakAdapter.findClientUuid(this.getRealmName(), this.getClientId());
                    userResource.roles().clientLevel(clientUuid).add(joiningRoles);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported roleType " + roleType);
                }
            }
        }
        catch (NotFoundException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            throw new UserNotFoundException(identifier, e);
        }
    }

    public void leaveRoles(UserIdentifier identifier, RoleType roleType, RoleName ... roleNames) throws UserNotFoundException {
        Validate.notNull((Object)identifier, (String)"identifier may be not null", (Object[])new Object[0]);
        try {
            UserResource userResource = this.keycloakAdapter.findUsersResource(this.getRealmName()).get((String)identifier.getValue());
            List<RoleRepresentation> leavingRoles = this.findRoles(this.getRolesResource(roleType), roleNames);
            switch (roleType) {
                case REALM: {
                    userResource.roles().realmLevel().remove(leavingRoles);
                    break;
                }
                case CLIENT: {
                    String clientUuid = this.keycloakAdapter.findClientUuid(this.getRealmName(), this.getClientId());
                    userResource.roles().clientLevel(clientUuid).remove(leavingRoles);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported roleType " + roleType);
                }
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(identifier, e);
        }
    }

    private List<GroupId> findGroupIds(GroupName ... groupNames) {
        GroupsResource resource = this.keycloakAdapter.findGroupsResource(this.getRealmName());
        ArrayList<GroupId> searchedGroups = new ArrayList<GroupId>();
        for (GroupName groupName : groupNames) {
            List groups = resource.groups((String)groupName.getValue(), Integer.valueOf(0), Integer.valueOf(1));
            if (groups == null || groups.isEmpty()) {
                LOG.warn("Group (name='{}')\u00a0not found", groupName.getValue());
                continue;
            }
            searchedGroups.addAll(groups.stream().map(group -> GroupId.fromValue(group.getId())).collect(Collectors.toList()));
        }
        return searchedGroups;
    }

    private List<RoleRepresentation> findRoles(RolesResource resource, RoleName ... roleNames) {
        ArrayList<RoleRepresentation> searchedRoles = new ArrayList<RoleRepresentation>();
        for (RoleName roleName : roleNames) {
            RoleRepresentation role = resource.get((String)roleName.getValue()).toRepresentation();
            if (role == null) {
                LOG.warn("Role (name='{}') not found", roleName.getValue());
                continue;
            }
            searchedRoles.add(role);
        }
        return searchedRoles;
    }

    private RolesResource getRolesResource(RoleType roleType) {
        RealmName realmName = this.getRealmName();
        switch (roleType) {
            case REALM: {
                return this.keycloakAdapter.findRealmRolesResource(realmName);
            }
            case CLIENT: {
                return this.keycloakAdapter.findClientRolesResource(realmName, this.getClientId());
            }
        }
        throw new IllegalArgumentException("unsupported roleType " + roleType);
    }

    private RealmName getRealmName() {
        return RealmName.fromValue(this.serviceConfiguration.getRealm());
    }

    private ClientId getClientId() {
        return ClientId.fromValue(this.serviceConfiguration.getClientId());
    }
}

