/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.user;

import de.openknowledge.authentication.domain.ClientId;
import de.openknowledge.authentication.domain.KeycloakAdapter;
import de.openknowledge.authentication.domain.KeycloakServiceConfiguration;
import de.openknowledge.authentication.domain.RealmName;
import de.openknowledge.authentication.domain.error.ResponseErrorMessage;
import de.openknowledge.authentication.domain.group.GroupId;
import de.openknowledge.authentication.domain.group.GroupName;
import de.openknowledge.authentication.domain.role.RoleName;
import de.openknowledge.authentication.domain.role.RoleType;
import de.openknowledge.authentication.domain.user.Attribute;
import de.openknowledge.authentication.domain.user.EmailVerifiedMode;
import de.openknowledge.authentication.domain.user.UserAccount;
import de.openknowledge.authentication.domain.user.UserCreationFailedException;
import de.openknowledge.authentication.domain.user.UserIdentifier;
import de.openknowledge.authentication.domain.user.UserNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakUserService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakUserService.class);
    private KeycloakAdapter keycloakAdapter;
    private KeycloakServiceConfiguration serviceConfiguration;

    protected KeycloakUserService() {
    }

    @Inject
    public KeycloakUserService(KeycloakAdapter aKeycloakAdapter, KeycloakServiceConfiguration aServiceConfiguration) {
        this.keycloakAdapter = aKeycloakAdapter;
        this.serviceConfiguration = aServiceConfiguration;
    }

    @PostConstruct
    public void init() {
        LOG.debug("check configuration");
        this.serviceConfiguration.validate();
    }

    public boolean checkAlreadyExist(UserAccount userAccount) {
        UsersResource usersResource = this.keycloakAdapter.findUserResource(this.getRealmName());
        List existingUsersByUsername = usersResource.search((String)userAccount.getUsername().getValue());
        LOG.info("List size by username is: {}", existingUsersByUsername != null ? Integer.valueOf(existingUsersByUsername.size()) : "null");
        return existingUsersByUsername != null && !existingUsersByUsername.isEmpty();
    }

    public UserAccount createUser(UserAccount userAccount, EmailVerifiedMode mode) throws UserCreationFailedException {
        UserRepresentation newUser = this.extractUser(userAccount, mode);
        newUser.setCredentials(this.extractCredential(userAccount));
        newUser.setAttributes(this.extractAttributes(userAccount));
        Response response = this.keycloakAdapter.findUserResource(this.getRealmName()).create(newUser);
        if (response.getStatus() != 201) {
            ResponseErrorMessage message = (ResponseErrorMessage)response.readEntity(ResponseErrorMessage.class);
            throw new UserCreationFailedException(newUser.getUsername(), response.getStatus(), message.getErrorMessage());
        }
        String path = response.getLocation().getPath();
        String userId = path.replaceAll(".*/([^/]+)$", "$1");
        UserIdentifier userIdentifier = UserIdentifier.fromValue(userId);
        userAccount.setIdentifier(userIdentifier);
        return userAccount;
    }

    public UserAccount getUser(UserIdentifier userIdentifier) throws UserNotFoundException {
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(this.getRealmName()).get((String)userIdentifier.getValue());
            return new UserAccount(userResource.toRepresentation());
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    public void updateMailVerification(UserIdentifier userIdentifier) throws UserNotFoundException {
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(this.getRealmName()).get((String)userIdentifier.getValue());
            UserRepresentation user = userResource.toRepresentation();
            user.setEmailVerified(Boolean.valueOf(true));
            userResource.update(user);
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    public void joinGroups(UserIdentifier userIdentifier, GroupName ... groupNames) throws UserNotFoundException {
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(this.getRealmName()).get((String)userIdentifier.getValue());
            List<GroupId> joiningGroups = this.findGroupIds(groupNames);
            for (GroupId groupId : joiningGroups) {
                userResource.joinGroup((String)groupId.getValue());
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    public void leaveGroups(UserIdentifier userIdentifier, GroupName ... groupNames) throws UserNotFoundException {
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(this.getRealmName()).get((String)userIdentifier.getValue());
            List<GroupId> leavingGroups = this.findGroupIds(groupNames);
            for (GroupId groupId : leavingGroups) {
                userResource.leaveGroup((String)groupId.getValue());
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    public void joinRoles(UserIdentifier userIdentifier, RoleType roleType, RoleName ... roleNames) throws UserNotFoundException {
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(this.getRealmName()).get((String)userIdentifier.getValue());
            List<RoleRepresentation> joiningRoles = this.findRoles(this.getRolesResource(roleType), roleNames);
            switch (roleType) {
                case REALM: {
                    userResource.roles().realmLevel().add(joiningRoles);
                    break;
                }
                case CLIENT: {
                    userResource.roles().clientLevel((String)this.getClientId().getValue()).add(joiningRoles);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported roleType " + roleType);
                }
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    public void leaveRoles(UserIdentifier userIdentifier, RoleType roleType, RoleName ... roleNames) throws UserNotFoundException {
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(this.getRealmName()).get((String)userIdentifier.getValue());
            List<RoleRepresentation> leavingRoles = this.findRoles(this.getRolesResource(roleType), roleNames);
            switch (roleType) {
                case REALM: {
                    userResource.roles().realmLevel().remove(leavingRoles);
                    break;
                }
                case CLIENT: {
                    userResource.roles().clientLevel((String)this.getClientId().getValue()).remove(leavingRoles);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported roleType " + roleType);
                }
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    private UserRepresentation extractUser(UserAccount userAccount, EmailVerifiedMode mode) {
        UserRepresentation keycloakUser = new UserRepresentation();
        keycloakUser.setUsername((String)userAccount.getUsername().getValue());
        keycloakUser.setEmail((String)userAccount.getEmailAddress().getValue());
        keycloakUser.setEnabled(Boolean.valueOf(true));
        if (userAccount.getName() != null && userAccount.getName().getFirstName() != null) {
            keycloakUser.setFirstName((String)userAccount.getName().getFirstName().getValue());
        }
        if (userAccount.getName() != null && userAccount.getName().getLastName() != null) {
            keycloakUser.setLastName((String)userAccount.getName().getLastName().getValue());
        }
        if (EmailVerifiedMode.REQUIRED.equals((Object)mode)) {
            keycloakUser.setEmailVerified(Boolean.valueOf(false));
        } else if (EmailVerifiedMode.DEFAULT.equals((Object)mode)) {
            keycloakUser.setEmailVerified(Boolean.valueOf(true));
            userAccount.emailVerified();
        }
        return keycloakUser;
    }

    private List<CredentialRepresentation> extractCredential(UserAccount userAccount) {
        if (userAccount.getPassword() != null) {
            CredentialRepresentation credential = new CredentialRepresentation();
            credential.setValue((String)userAccount.getPassword().getValue());
            credential.setType("password");
            credential.setTemporary(Boolean.valueOf(false));
            return Collections.singletonList(credential);
        }
        return null;
    }

    private Map<String, List<String>> extractAttributes(UserAccount userAccount) {
        HashMap<String, List<String>> userAttributeMap = new HashMap<String, List<String>>();
        for (Attribute attribute : userAccount.getAttributes()) {
            List<String> userAttributeList = userAttributeMap.containsKey(attribute.getKey()) ? (List)userAttributeMap.get(attribute.getKey()) : new ArrayList<String>();
            userAttributeList.add(attribute.getValue());
            userAttributeMap.put(attribute.getKey(), userAttributeList);
        }
        return userAttributeMap;
    }

    private List<GroupId> findGroupIds(GroupName ... groupNames) {
        GroupsResource resource = this.keycloakAdapter.findGroupResource(this.getRealmName());
        ArrayList<GroupId> searchedGroups = new ArrayList<GroupId>();
        for (GroupName groupName : groupNames) {
            List groups = resource.groups((String)groupName.getValue(), Integer.valueOf(0), Integer.valueOf(1));
            if (groups == null || groups.isEmpty()) {
                LOG.warn("Group (name='{}')\u00a0not found", groupName.getValue());
                continue;
            }
            searchedGroups.addAll(groups.stream().map(group -> GroupId.fromValue(group.getId())).collect(Collectors.toList()));
        }
        return searchedGroups;
    }

    private List<RoleRepresentation> findRoles(RolesResource resource, RoleName ... roleNames) {
        ArrayList<RoleRepresentation> searchedRoles = new ArrayList<RoleRepresentation>();
        for (RoleName roleName : roleNames) {
            List roles = resource.list((String)roleName.getValue(), Integer.valueOf(0), Integer.valueOf(1));
            if (roles == null || roles.isEmpty()) {
                LOG.warn("Role (name='{}') not found", roleName.getValue());
                continue;
            }
            searchedRoles.addAll(roles);
        }
        return searchedRoles;
    }

    private RolesResource getRolesResource(RoleType roleType) {
        RealmName realmName = this.getRealmName();
        switch (roleType) {
            case REALM: {
                return this.keycloakAdapter.findRealmRolesResource(realmName);
            }
            case CLIENT: {
                return this.keycloakAdapter.findClientRolesResource(realmName, this.getClientId());
            }
        }
        throw new IllegalArgumentException("unsupported roleType " + roleType);
    }

    private RealmName getRealmName() {
        return RealmName.fromValue(this.serviceConfiguration.getRealm());
    }

    private ClientId getClientId() {
        return ClientId.fromValue(this.serviceConfiguration.getClientId());
    }
}

