/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.token;

import de.openknowledge.authentication.domain.token.KeycloakKeyConfiguration;
import de.openknowledge.authentication.domain.token.KeycloakKeyService;
import de.openknowledge.authentication.domain.token.Token;
import de.openknowledge.authentication.domain.token.TokenSecret;
import de.openknowledge.authentication.domain.token.VerificationLink;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.PostConstruct;
import javax.crypto.spec.SecretKeySpec;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.bind.JsonbBuilder;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jwe.JWEHeader;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.alg.RsaKeyEncryptionJWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.AesCbcHmacShaEncryptionProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakTokenService.class);
    private KeycloakKeyConfiguration keyConfiguration;
    private KeyPair keyPair;
    private TokenSecret tokenSecret;

    protected KeycloakTokenService() {
    }

    @Inject
    public KeycloakTokenService(KeycloakKeyConfiguration aKeyConfiguration) {
        this.keyConfiguration = aKeyConfiguration;
    }

    @PostConstruct
    public void init() {
        LOG.debug("check configuration");
        this.keyConfiguration.validate();
        this.keyPair = KeycloakKeyService.readKeyPair(this.keyConfiguration);
        this.tokenSecret = TokenSecret.fromValue(this.keyConfiguration.getTokenSecret());
    }

    public VerificationLink encode(Token token) {
        try {
            String payload = JsonbBuilder.create().toJson((Object)token);
            LOG.debug("payload: {}", (Object)payload);
            JWE jwe = this.jwtEncode(this.tokenSecret, this.keyPair.getPublic());
            jwe.content(payload.getBytes(StandardCharsets.UTF_8));
            String encodedPayload = jwe.encodeJwe(this.getAlgorithmProvider(), this.getEncryptionProvider());
            LOG.debug("encoded payload: {}", (Object)encodedPayload);
            return VerificationLink.fromValue(encodedPayload);
        }
        catch (JWEException e) {
            LOG.error("problem during encode JWT: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("problem during encode" + e.getMessage(), e);
        }
    }

    public Token decode(VerificationLink link) {
        try {
            LOG.debug("payload: {}", link.getValue());
            JWE jwe = this.jwtDecoder(this.tokenSecret, this.keyPair.getPrivate());
            jwe.verifyAndDecodeJwe((String)link.getValue(), this.getAlgorithmProvider(), this.getEncryptionProvider());
            String decodedPayload = new String(jwe.getContent(), StandardCharsets.UTF_8);
            LOG.debug("decoded payload: {}", (Object)decodedPayload);
            return (Token)JsonbBuilder.create().fromJson(decodedPayload, Token.class);
        }
        catch (JWEException e) {
            LOG.error("problem during decode JWT: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("problem during decode" + e.getMessage(), e);
        }
    }

    private JWE jwtEncode(TokenSecret tokenSecret, PublicKey encryptionKey) {
        JWEHeader jweHeader = new JWEHeader("A256CBC-HS512", "A256CBC-HS512", null);
        JWE jwe = new JWE();
        jwe.header(jweHeader);
        jwe.getKeyStorage().setEncryptionKey((Key)encryptionKey);
        this.enrichKeyStorage(jwe, tokenSecret);
        return jwe;
    }

    private JWE jwtDecoder(TokenSecret tokenSecret, PrivateKey decryptionKey) {
        JWE jwe = new JWE();
        jwe.getKeyStorage().setDecryptionKey((Key)decryptionKey);
        this.enrichKeyStorage(jwe, tokenSecret);
        return jwe;
    }

    private void enrichKeyStorage(JWE jwe, TokenSecret tokenSecret) {
        SecretKeySpec aesKey = new SecretKeySpec(tokenSecret.asByteArray(), "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(tokenSecret.asByteArray(), "HMACSHA2");
        jwe.getKeyStorage().setCEKKey((Key)aesKey, JWEKeyStorage.KeyUse.ENCRYPTION);
        jwe.getKeyStorage().setCEKKey((Key)hmacKey, JWEKeyStorage.KeyUse.SIGNATURE);
    }

    private JWEAlgorithmProvider getAlgorithmProvider() {
        return new RsaKeyEncryptionJWEAlgorithmProvider("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
    }

    private JWEEncryptionProvider getEncryptionProvider() {
        return new AesCbcHmacShaEncryptionProvider.Aes256CbcHmacSha512Provider();
    }
}

