/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.login;

import de.openknowledge.authentication.domain.KeycloakAdapter;
import de.openknowledge.authentication.domain.KeycloakServiceConfiguration;
import de.openknowledge.authentication.domain.login.Login;
import de.openknowledge.authentication.domain.login.LoginToken;
import de.openknowledge.authentication.domain.login.RefreshToken;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Form;
import org.keycloak.representations.AccessTokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakLoginService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakLoginService.class);
    private KeycloakAdapter keycloakAdapter;
    private KeycloakServiceConfiguration serviceConfiguration;

    protected KeycloakLoginService() {
    }

    @Inject
    public KeycloakLoginService(KeycloakAdapter aKeycloakAdapter, KeycloakServiceConfiguration aServiceConfiguration) {
        this.keycloakAdapter = aKeycloakAdapter;
        this.serviceConfiguration = aServiceConfiguration;
    }

    @PostConstruct
    public void init() {
        LOG.debug("check configuration");
        this.serviceConfiguration.validate();
    }

    public LoginToken login(Login login) {
        AccessTokenResponse response = this.grantToken(login);
        return new LoginToken(response.getToken(), response.getExpiresIn(), response.getRefreshToken(), response.getRefreshExpiresIn());
    }

    public LoginToken refresh(RefreshToken refreshToken) {
        AccessTokenResponse response = this.refreshToken(refreshToken);
        return new LoginToken(response.getToken(), response.getExpiresIn(), response.getRefreshToken(), response.getRefreshExpiresIn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenResponse grantToken(Login login) {
        Form form = new Form().param("grant_type", "password").param("username", (String)login.getUsername().getValue()).param("password", (String)login.getPassword().getValue()).param("client_id", this.serviceConfiguration.getClientId());
        KeycloakLoginService keycloakLoginService = this;
        synchronized (keycloakLoginService) {
            return this.keycloakAdapter.getTokenService().grantToken(this.serviceConfiguration.getRealm(), form.asMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessTokenResponse refreshToken(RefreshToken refreshToken) {
        Form form = new Form().param("grant_type", "refresh_token").param("refresh_token", (String)refreshToken.getValue()).param("client_id", this.serviceConfiguration.getClientId());
        KeycloakLoginService keycloakLoginService = this;
        synchronized (keycloakLoginService) {
            return this.keycloakAdapter.getTokenService().refreshToken(this.serviceConfiguration.getRealm(), form.asMap());
        }
    }
}

