/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.user;

import de.openknowledge.authentication.domain.KeycloakAdapter;
import de.openknowledge.authentication.domain.KeycloakServiceConfiguration;
import de.openknowledge.authentication.domain.RealmName;
import de.openknowledge.authentication.domain.group.GroupId;
import de.openknowledge.authentication.domain.group.GroupName;
import de.openknowledge.authentication.domain.role.RoleName;
import de.openknowledge.authentication.domain.user.Attribute;
import de.openknowledge.authentication.domain.user.EmailVerifiedMode;
import de.openknowledge.authentication.domain.user.UserAccount;
import de.openknowledge.authentication.domain.user.UserCreationFailedException;
import de.openknowledge.authentication.domain.user.UserIdentifier;
import de.openknowledge.authentication.domain.user.UserNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.resource.GroupsResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakUserService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakUserService.class);
    private KeycloakAdapter keycloakAdapter;
    private KeycloakServiceConfiguration serviceConfiguration;

    protected KeycloakUserService() {
    }

    @Inject
    public KeycloakUserService(KeycloakAdapter aKeycloakAdapter, KeycloakServiceConfiguration aServiceConfiguration) {
        this.keycloakAdapter = aKeycloakAdapter;
        this.serviceConfiguration = aServiceConfiguration;
    }

    @PostConstruct
    public void init() {
        LOG.debug("check configuration");
        this.serviceConfiguration.validate();
    }

    public boolean checkAlreadyExist(UserAccount userAccount) {
        UsersResource usersResource = this.keycloakAdapter.findUserResource(this.getRealmName());
        List existingUsersByUsername = usersResource.search((String)userAccount.getUsername().getValue());
        LOG.info("List size by username is: {}", existingUsersByUsername != null ? Integer.valueOf(existingUsersByUsername.size()) : "null");
        return existingUsersByUsername != null && !existingUsersByUsername.isEmpty();
    }

    public UserAccount createUser(UserAccount userAccount, EmailVerifiedMode mode) throws UserCreationFailedException {
        UserRepresentation newUser = this.extractUser(userAccount, mode);
        newUser.setCredentials(this.extractCredential(userAccount));
        newUser.setAttributes(this.extractAttributes(userAccount));
        Response response = this.keycloakAdapter.findUserResource(this.getRealmName()).create(newUser);
        if (response.getStatus() != 201) {
            throw new UserCreationFailedException(newUser.getUsername(), response.getStatus());
        }
        String path = response.getLocation().getPath();
        String userId = path.replaceAll(".*/([^/]+)$", "$1");
        UserIdentifier userIdentifier = UserIdentifier.fromValue(userId);
        userAccount.setIdentifier(userIdentifier);
        return userAccount;
    }

    public UserAccount getUser(UserIdentifier userIdentifier) throws UserNotFoundException {
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(this.getRealmName()).get((String)userIdentifier.getValue());
            return new UserAccount(userResource.toRepresentation());
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    public void updateMailVerification(UserIdentifier userIdentifier) throws UserNotFoundException {
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(this.getRealmName()).get((String)userIdentifier.getValue());
            UserRepresentation user = userResource.toRepresentation();
            user.setEmailVerified(Boolean.valueOf(true));
            userResource.update(user);
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    public void joinGroups(UserIdentifier userIdentifier, GroupName ... groupNames) throws UserNotFoundException {
        RealmName realmName = this.getRealmName();
        GroupsResource resource = this.keycloakAdapter.findGroupResource(realmName);
        ArrayList joiningGroups = new ArrayList();
        for (GroupName groupName : groupNames) {
            List groups = resource.groups((String)groupName.getValue(), Integer.valueOf(0), Integer.valueOf(1));
            if (groups == null || groups.isEmpty()) {
                LOG.warn("Group (name='{}')\u00a0not found", groupName.getValue());
                continue;
            }
            joiningGroups.addAll(groups.stream().map(group -> GroupId.fromValue(group.getId())).collect(Collectors.toList()));
        }
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(realmName).get((String)userIdentifier.getValue());
            for (GroupId groupId : joiningGroups) {
                userResource.joinGroup((String)groupId.getValue());
            }
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    public void joinRoles(UserIdentifier userIdentifier, RoleName ... roleNames) throws UserNotFoundException {
        RealmName realmName = this.getRealmName();
        RolesResource resource = this.keycloakAdapter.findRoleResource(realmName);
        ArrayList joiningRoles = new ArrayList();
        for (RoleName roleName : roleNames) {
            List roles = resource.list((String)roleName.getValue(), Integer.valueOf(0), Integer.valueOf(1));
            if (roles == null || roles.isEmpty()) {
                LOG.warn("Role (name='{}') not found", roleName.getValue());
                continue;
            }
            joiningRoles.addAll(roles);
        }
        try {
            UserResource userResource = this.keycloakAdapter.findUserResource(realmName).get((String)userIdentifier.getValue());
            userResource.roles().realmLevel().add(joiningRoles);
        }
        catch (NotFoundException e) {
            throw new UserNotFoundException(userIdentifier);
        }
    }

    private UserRepresentation extractUser(UserAccount userAccount, EmailVerifiedMode mode) {
        UserRepresentation keycloakUser = new UserRepresentation();
        keycloakUser.setUsername((String)userAccount.getUsername().getValue());
        keycloakUser.setEmail((String)userAccount.getEmailAddress().getValue());
        keycloakUser.setEnabled(Boolean.valueOf(true));
        if (userAccount.getName() != null && userAccount.getName().getFirstName() != null) {
            keycloakUser.setFirstName((String)userAccount.getName().getFirstName().getValue());
        }
        if (userAccount.getName() != null && userAccount.getName().getLastName() != null) {
            keycloakUser.setLastName((String)userAccount.getName().getLastName().getValue());
        }
        if (EmailVerifiedMode.REQUIRED.equals((Object)mode)) {
            keycloakUser.setEmailVerified(Boolean.valueOf(false));
        } else if (EmailVerifiedMode.DEFAULT.equals((Object)mode)) {
            keycloakUser.setEmailVerified(Boolean.valueOf(true));
            userAccount.emailVerified();
        }
        return keycloakUser;
    }

    private List<CredentialRepresentation> extractCredential(UserAccount userAccount) {
        if (userAccount.getPassword() != null) {
            CredentialRepresentation credential = new CredentialRepresentation();
            credential.setValue((String)userAccount.getPassword().getValue());
            credential.setType("password");
            credential.setTemporary(Boolean.valueOf(false));
            return Collections.singletonList(credential);
        }
        return null;
    }

    private Map<String, List<String>> extractAttributes(UserAccount userAccount) {
        HashMap<String, List<String>> userAttributeMap = new HashMap<String, List<String>>();
        for (Attribute attribute : userAccount.getAttributes()) {
            List<String> userAttributeList = userAttributeMap.containsKey(attribute.getKey()) ? (List)userAttributeMap.get(attribute.getKey()) : new ArrayList<String>();
            userAttributeList.add(attribute.getValue());
            userAttributeMap.put(attribute.getKey(), userAttributeList);
        }
        return userAttributeMap;
    }

    private RealmName getRealmName() {
        return RealmName.fromValue(this.serviceConfiguration.getRealm());
    }
}

