/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.registration;

import de.openknowledge.authentication.domain.ClientId;
import de.openknowledge.authentication.domain.KeycloakServiceConfiguration;
import de.openknowledge.authentication.domain.registration.InvalidTokenException;
import de.openknowledge.authentication.domain.registration.Issuer;
import de.openknowledge.authentication.domain.registration.KeycloakRegistrationServiceConfiguration;
import de.openknowledge.authentication.domain.registration.RegistrationFailedException;
import de.openknowledge.authentication.domain.registration.RegistrationMode;
import de.openknowledge.authentication.domain.registration.RegistrationRequirement;
import de.openknowledge.authentication.domain.role.RoleName;
import de.openknowledge.authentication.domain.token.KeycloakTokenService;
import de.openknowledge.authentication.domain.token.Token;
import de.openknowledge.authentication.domain.token.VerificationLink;
import de.openknowledge.authentication.domain.user.EmailVerifiedMode;
import de.openknowledge.authentication.domain.user.KeycloakUserService;
import de.openknowledge.authentication.domain.user.UserAccount;
import de.openknowledge.authentication.domain.user.UserCreationFailedException;
import de.openknowledge.authentication.domain.user.UserIdentifier;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KeycloakRegistrationService {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakRegistrationService.class);
    private KeycloakUserService keycloakUserService;
    private KeycloakTokenService keycloakTokenService;
    private KeycloakServiceConfiguration serviceConfiguration;
    private KeycloakRegistrationServiceConfiguration registrationServiceConfiguration;

    protected KeycloakRegistrationService() {
    }

    @Inject
    public KeycloakRegistrationService(KeycloakServiceConfiguration aServiceConfiguration, KeycloakRegistrationServiceConfiguration aRegistrationServiceConfiguration, KeycloakUserService aKeycloakUserService, KeycloakTokenService aKeycloakTokenService) {
        this.keycloakUserService = aKeycloakUserService;
        this.keycloakTokenService = aKeycloakTokenService;
        this.serviceConfiguration = aServiceConfiguration;
        this.registrationServiceConfiguration = aRegistrationServiceConfiguration;
    }

    @PostConstruct
    public void init() {
        LOG.debug("check configuration");
        this.serviceConfiguration.validate();
        this.registrationServiceConfiguration.validate();
    }

    public UserAccount register(UserAccount userAccount) throws RegistrationFailedException {
        UserAccount newUserAccount;
        Validate.notNull((Object)userAccount, (String)"userAccount may not be null", (Object[])new Object[0]);
        if (this.keycloakUserService.checkAlreadyExist(userAccount)) {
            throw new RegistrationFailedException((String)userAccount.getUsername().getValue());
        }
        try {
            EmailVerifiedMode emailVerifiedMode = this.getEmailVerifiedMode();
            newUserAccount = this.keycloakUserService.createUser(userAccount, emailVerifiedMode);
        }
        catch (UserCreationFailedException e) {
            throw new RegistrationFailedException(e);
        }
        if (this.isRoleRequired()) {
            ClientId clientId = ClientId.fromValue(this.serviceConfiguration.getClientId());
            this.keycloakUserService.joinRoles(newUserAccount.getIdentifier(), RoleName.fromValue((String)clientId.getValue()));
        }
        return userAccount;
    }

    public UserIdentifier verifyEmailAddress(VerificationLink link, Issuer issuer) throws InvalidTokenException {
        Token token = this.keycloakTokenService.decode(link);
        if (!token.isValid(issuer)) {
            throw new InvalidTokenException(token, issuer);
        }
        UserIdentifier userIdentifier = token.asUserIdentifier();
        this.keycloakUserService.updateMailVerification(userIdentifier);
        return userIdentifier;
    }

    public VerificationLink createVerificationLink(UserAccount userAccount, Issuer issuer) {
        Integer tokenLifeTime = Integer.parseInt(this.registrationServiceConfiguration.getTokenLifeTime());
        TimeUnit timeUnit = TimeUnit.valueOf(this.registrationServiceConfiguration.getTimeUnit());
        Token token = userAccount.asToken(issuer, tokenLifeTime, timeUnit);
        return this.keycloakTokenService.encode(token);
    }

    public KeycloakUserService getKeycloakUserService() {
        return this.keycloakUserService;
    }

    private EmailVerifiedMode getEmailVerifiedMode() {
        switch (RegistrationMode.fromValue(this.registrationServiceConfiguration.getRegistrationMode())) {
            case DOUBLE_OPT_IN: {
                return EmailVerifiedMode.REQUIRED;
            }
            case DEFAULT: {
                return EmailVerifiedMode.DEFAULT;
            }
        }
        throw new IllegalArgumentException("unsupported RegistrationMode " + this.registrationServiceConfiguration.getRegistrationMode());
    }

    private boolean isRoleRequired() {
        return RegistrationRequirement.ROLE.equals((Object)RegistrationRequirement.fromValue(this.registrationServiceConfiguration.getRegistrationRequirement()));
    }
}

