/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain;

import de.openknowledge.authentication.domain.InvalidConfigurationException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class KeycloakServiceConfiguration {
    private static final String REALM_PROPERTY = "keycloak.service.realm";
    private static final String CLIENT_ID_PROPERTY = "keycloak.service.clientId";
    private static final String REALM_DEFAULT = "missingRealm";
    private static final String CLIENT_ID_DEFAULT = "missingClientId";
    private String realm;
    private String clientId;

    protected KeycloakServiceConfiguration() {
    }

    @Inject
    public KeycloakServiceConfiguration(@ConfigProperty(name="keycloak.service.realm", defaultValue="missingRealm") String aRealm, @ConfigProperty(name="keycloak.service.clientId", defaultValue="missingClientId") String aClientId) {
        this.realm = aRealm;
        this.clientId = aClientId;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void validate() {
        if (REALM_DEFAULT.equals(this.getRealm())) {
            throw new InvalidConfigurationException(REALM_PROPERTY);
        }
        if (CLIENT_ID_DEFAULT.equals(this.getClientId())) {
            throw new InvalidConfigurationException(CLIENT_ID_PROPERTY);
        }
    }
}

