/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.authentication.domain.registration;

import de.openknowledge.authentication.domain.login.EmailAddress;
import de.openknowledge.authentication.domain.login.Username;
import de.openknowledge.authentication.domain.registration.Issuer;
import de.openknowledge.authentication.domain.registration.RegistrationMode;
import de.openknowledge.authentication.domain.user.UserIdentifier;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbTransient;
import org.keycloak.common.util.Time;

public class Token {
    @JsonbProperty(value="jti")
    private String tokenId;
    @JsonbProperty(value="sub")
    private String userIdentifier;
    @JsonbProperty(value="upn")
    private String username;
    @JsonbProperty(value="email")
    private String email;
    @JsonbProperty(value="exp")
    private Integer expiration;
    @JsonbProperty(value="nbf")
    private Integer notBefore;
    @JsonbProperty(value="iat")
    private Integer issuedAt;
    @JsonbProperty(value="iss")
    private String issuer;
    @JsonbProperty(value="typ")
    private String type;

    protected Token() {
    }

    public Token(Username anUsername, UserIdentifier anUserIdentifier, EmailAddress anEmailAddress, Issuer anIssuer, Integer timeToLive, TimeUnit timeUnit) {
        this.setTokenId(UUID.randomUUID().toString());
        this.setUserIdentifier((String)anUserIdentifier.getValue());
        this.setUsername((String)anUsername.getValue());
        this.setEmail((String)anEmailAddress.getValue());
        this.setIssuer((String)anIssuer.getValue());
        this.setType(RegistrationMode.DOUBLE_OPT_IN.name());
        this.setIssuedAt(Time.currentTime());
        this.setNotBefore(this.issuedAt);
        this.setExpiration(this.calculateExpiration(this.issuedAt, timeToLive, timeUnit));
    }

    @JsonbTransient
    public UserIdentifier asUserIdentifier() {
        return UserIdentifier.fromValue(this.userIdentifier);
    }

    @JsonbTransient
    public boolean isValid(Issuer issuer) {
        return this.isValid(100, issuer);
    }

    @JsonbTransient
    public boolean isValid(int allowedTimeSkew, Issuer issuer) {
        if (issuer == null) {
            throw new IllegalArgumentException("issuer may not be null");
        }
        return this.isActive(allowedTimeSkew) && ((String)issuer.getValue()).equals(this.getIssuer());
    }

    @JsonbTransient
    public boolean isExpired() {
        return Time.currentTime() > this.expiration;
    }

    @JsonbTransient
    public boolean isActive(int allowedTimeSkew) {
        return !(this.isExpired() && this.expiration != 0 || !this.isNotBefore(allowedTimeSkew) && this.notBefore != 0);
    }

    @JsonbTransient
    public boolean isNotBefore(int allowedTimeSkew) {
        return Time.currentTime() + allowedTimeSkew >= this.notBefore;
    }

    @JsonbTransient
    public int getTtlInMinutes() {
        return (this.expiration - this.issuedAt) / 60;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public int getIssuedAt() {
        return this.issuedAt;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getType() {
        return this.type;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public void setUserIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setExpiration(Integer expiration) {
        this.expiration = expiration;
    }

    public void setNotBefore(Integer notBefore) {
        this.notBefore = notBefore;
    }

    public void setIssuedAt(Integer issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals(this.getTokenId(), token.getTokenId()) && Objects.equals(this.getUserIdentifier(), token.getUserIdentifier()) && Objects.equals(this.getUsername(), token.getUsername()) && Objects.equals(this.getEmail(), token.getEmail()) && Objects.equals(this.getExpiration(), token.getExpiration()) && Objects.equals(this.getNotBefore(), token.getNotBefore()) && Objects.equals(this.getIssuedAt(), token.getIssuedAt()) && Objects.equals(this.getIssuer(), token.getIssuer()) && Objects.equals(this.getType(), token.getType());
    }

    public int hashCode() {
        return Objects.hash(this.getTokenId(), this.getUserIdentifier(), this.getUsername(), this.getEmail(), this.getExpiration(), this.getNotBefore(), this.getIssuedAt(), this.getIssuer(), this.getType());
    }

    public String toString() {
        return "Token{tokenId='" + this.tokenId + "', username='" + this.username + "', userIdentifier='" + this.userIdentifier + "', email='" + this.email + "', expiration=" + this.expiration + ", notBefore=" + this.notBefore + ", issuedAt=" + this.issuedAt + ", issuer='" + this.issuer + "', type='" + this.type + "'}";
    }

    private int calculateExpiration(int now, int ttl, TimeUnit timeUnit) {
        switch (timeUnit) {
            case SECONDS: {
                return now + ttl;
            }
            case MINUTES: {
                return now + ttl * 60;
            }
            case HOURS: {
                return now + ttl * 3600;
            }
            case DAYS: {
                return now + ttl * 3600 * 24;
            }
            case MILLISECONDS: {
                return now + ttl / 1000;
            }
        }
        throw new IllegalArgumentException("timeUnit '" + timeUnit + "' is unsupported: use SECONDS, MINUTES, HOURS, DAYS");
    }
}

